/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.AbstractMember;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.MemberVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class MemberImpl
extends AbstractMember
implements Member,
IdentifiedDataSerializable {
    public static final int NA_MEMBER_LIST_JOIN_VERSION = -1;
    private boolean localMember;
    private volatile int memberListJoinVersion = -1;
    private volatile ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, MemberVersion version, boolean localMember) {
        this(MemberImpl.newHashMap(EndpointQualifier.MEMBER, address), address, version, localMember, null, null, false, -1);
    }

    public MemberImpl(Address address, MemberVersion version, boolean localMember, UUID uuid) {
        this(MemberImpl.newHashMap(EndpointQualifier.MEMBER, address), address, version, localMember, uuid, null, false, -1);
    }

    public MemberImpl(MemberImpl member) {
        super(member);
        this.localMember = member.localMember;
        this.memberListJoinVersion = member.memberListJoinVersion;
    }

    private MemberImpl(Map<EndpointQualifier, Address> addresses, Address address, MemberVersion version, boolean localMember, UUID uuid, Map<String, String> attributes, boolean liteMember, int memberListJoinVersion) {
        super(addresses, address, version, uuid, attributes, liteMember);
        this.memberListJoinVersion = memberListJoinVersion;
        this.localMember = localMember;
    }

    @Override
    protected ILogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean localMember() {
        return this.localMember;
    }

    @Override
    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public int getMemberListJoinVersion() {
        return this.memberListJoinVersion;
    }

    private void ensureLocalMember() {
        if (!this.localMember) {
            throw new UnsupportedOperationException("Attributes on remote members must not be changed");
        }
    }

    public void setAttribute(String key, String value) {
        this.ensureLocalMember();
        Preconditions.isNotNull(key, "key");
        Preconditions.isNotNull(value, "value");
        this.attributes.put(key, value);
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    private static Map<EndpointQualifier, Address> newHashMap(EndpointQualifier member, Address address) {
        HashMap<EndpointQualifier, Address> result = new HashMap<EndpointQualifier, Address>();
        result.put(member, address);
        return result;
    }

    public static class Builder {
        private Address address;
        private Map<EndpointQualifier, Address> addressMap;
        private Map<String, String> attributes;
        private boolean localMember;
        private UUID uuid;
        private boolean liteMember;
        private MemberVersion version;
        private int memberListJoinVersion = -1;

        public Builder(Address address) {
            Preconditions.isNotNull(address, "address");
            this.address = address;
        }

        public Builder(Map<EndpointQualifier, Address> addresses) {
            Preconditions.isNotNull(addresses, "addresses");
            Preconditions.isNotNull(addresses.get(EndpointQualifier.MEMBER), "addresses.get(MEMBER)");
            this.addressMap = addresses;
        }

        public Builder address(Address address) {
            this.address = Preconditions.isNotNull(address, "address");
            return this;
        }

        public Builder localMember(boolean localMember) {
            this.localMember = localMember;
            return this;
        }

        public Builder version(MemberVersion memberVersion) {
            this.version = memberVersion;
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder memberListJoinVersion(int memberListJoinVersion) {
            this.memberListJoinVersion = memberListJoinVersion;
            return this;
        }

        public Builder liteMember(boolean liteMember) {
            this.liteMember = liteMember;
            return this;
        }

        public MemberImpl build() {
            if (this.addressMap == null) {
                this.addressMap = MemberImpl.newHashMap(EndpointQualifier.MEMBER, this.address);
            }
            if (this.address == null) {
                this.address = this.addressMap.get(EndpointQualifier.MEMBER);
            }
            return new MemberImpl(this.addressMap, this.address, this.version, this.localMember, this.uuid, this.attributes, this.liteMember, this.memberListJoinVersion);
        }
    }
}

