/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.MapUtil;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigXmlGenerator {
    public static final String MASK_FOR_SENSITIVE_DATA = "****";

    private ConfigXmlGenerator() {
    }

    public static final class XmlGenerator {
        private static final int CAPACITY = 64;
        private final StringBuilder xml;
        private final ArrayDeque<String> openNodes = new ArrayDeque();

        public XmlGenerator(StringBuilder xml) {
            this.xml = xml;
        }

        public XmlGenerator open(String name, Object ... attributes) {
            XmlGenerator.appendOpenNode(this.xml, name, attributes);
            this.openNodes.addLast(name);
            return this;
        }

        public XmlGenerator node(String name, Object contents, Object ... attributes) {
            XmlGenerator.appendNode(this.xml, name, contents, attributes);
            return this;
        }

        public XmlGenerator nodeIfContents(String name, Object contents, Object ... attributes) {
            if (contents != null) {
                XmlGenerator.appendNode(this.xml, name, contents, attributes);
            }
            return this;
        }

        public XmlGenerator close() {
            XmlGenerator.appendCloseNode(this.xml, this.openNodes.pollLast());
            return this;
        }

        public XmlGenerator appendLabels(Set<String> labels) {
            if (!labels.isEmpty()) {
                this.open("client-labels", new Object[0]);
                for (String label : labels) {
                    this.node("label", label, new Object[0]);
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Properties props) {
            if (!props.isEmpty()) {
                this.open("properties", new Object[0]);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    this.node("property", props.getProperty(key.toString()), "name", key.toString());
                }
                this.close();
            }
            return this;
        }

        public XmlGenerator appendProperties(Map<String, ? extends Comparable> props) {
            if (!MapUtil.isNullOrEmpty(props)) {
                this.open("properties", new Object[0]);
                for (Map.Entry<String, ? extends Comparable> entry : props.entrySet()) {
                    this.node("property", entry.getValue(), "name", entry.getKey());
                }
                this.close();
            }
            return this;
        }

        private static void appendOpenNode(StringBuilder xml, String name, Object ... attributes) {
            xml.append('<').append(name);
            XmlGenerator.appendAttributes(xml, attributes);
            xml.append('>');
        }

        private static void appendCloseNode(StringBuilder xml, String name) {
            xml.append("</").append(name).append('>');
        }

        private static void appendNode(StringBuilder xml, String name, Object contents, Object ... attributes) {
            if (contents != null || attributes.length > 0) {
                xml.append('<').append(name);
                XmlGenerator.appendAttributes(xml, attributes);
                if (contents != null) {
                    xml.append('>');
                    XmlGenerator.escapeXml(contents, xml);
                    xml.append("</").append(name).append('>');
                } else {
                    xml.append("/>");
                }
            }
        }

        private static void appendAttributes(StringBuilder xml, Object ... attributes) {
            int i = 0;
            while (i < attributes.length) {
                Object attributeValue;
                Object attributeName = attributes[i++];
                if ((attributeValue = attributes[i++]) == null) continue;
                xml.append(" ").append(attributeName).append("=\"");
                XmlGenerator.escapeXmlAttr(attributeValue, xml);
                xml.append("\"");
            }
        }

        private static void escapeXml(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                if (ch == '<') {
                    appendTo.append("&lt;");
                    continue;
                }
                if (ch == '&') {
                    appendTo.append("&amp;");
                    continue;
                }
                appendTo.append(ch);
            }
        }

        private static void escapeXmlAttr(Object o, StringBuilder appendTo) {
            if (o == null) {
                appendTo.append("null");
                return;
            }
            String s = o.toString();
            int length = s.length();
            appendTo.ensureCapacity(appendTo.length() + length + 64);
            block8: for (int i = 0; i < length; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\n': {
                        appendTo.append("&#10;");
                        continue block8;
                    }
                    case '\r': {
                        appendTo.append("&#13;");
                        continue block8;
                    }
                    case '\"': {
                        appendTo.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        appendTo.append("&#39;");
                        continue block8;
                    }
                    case '&': {
                        appendTo.append("&amp;");
                        continue block8;
                    }
                    case '<': {
                        appendTo.append("&lt;");
                        continue block8;
                    }
                    default: {
                        appendTo.append(ch);
                    }
                }
            }
        }
    }
}

