/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.discovery.NodeFilter;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DiscoveryConfig {
    private List<DiscoveryStrategyConfig> discoveryStrategyConfigs = new ArrayList<DiscoveryStrategyConfig>();
    private DiscoveryServiceProvider discoveryServiceProvider;
    private NodeFilter nodeFilter;
    private String nodeFilterClass;

    public DiscoveryConfig() {
    }

    protected DiscoveryConfig(DiscoveryServiceProvider discoveryServiceProvider, NodeFilter nodeFilter, String nodeFilterClass, Collection<DiscoveryStrategyConfig> discoveryStrategyConfigs) {
        this.discoveryServiceProvider = discoveryServiceProvider;
        this.nodeFilter = nodeFilter;
        this.nodeFilterClass = nodeFilterClass;
        this.discoveryStrategyConfigs.addAll(discoveryStrategyConfigs);
    }

    public DiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryStrategyConfigs = new ArrayList<DiscoveryStrategyConfig>(discoveryConfig.discoveryStrategyConfigs);
        this.discoveryServiceProvider = discoveryConfig.discoveryServiceProvider;
        this.nodeFilter = discoveryConfig.nodeFilter;
        this.nodeFilterClass = discoveryConfig.nodeFilterClass;
    }

    public DiscoveryConfig setDiscoveryServiceProvider(DiscoveryServiceProvider discoveryServiceProvider) {
        this.discoveryServiceProvider = discoveryServiceProvider;
        return this;
    }

    public DiscoveryServiceProvider getDiscoveryServiceProvider() {
        return this.discoveryServiceProvider;
    }

    public NodeFilter getNodeFilter() {
        return this.nodeFilter;
    }

    public DiscoveryConfig setNodeFilter(@Nonnull NodeFilter nodeFilter) {
        this.nodeFilter = Preconditions.checkNotNull(nodeFilter, "Node filter cannot be null!");
        this.nodeFilterClass = null;
        return this;
    }

    public String getNodeFilterClass() {
        return this.nodeFilterClass;
    }

    public DiscoveryConfig setNodeFilterClass(@Nonnull String nodeFilterClass) {
        this.nodeFilterClass = Preconditions.checkHasText(nodeFilterClass, "Node filter class name must contain text");
        this.nodeFilter = null;
        return this;
    }

    public boolean isEnabled() {
        return !this.discoveryStrategyConfigs.isEmpty();
    }

    public Collection<DiscoveryStrategyConfig> getDiscoveryStrategyConfigs() {
        return this.discoveryStrategyConfigs;
    }

    public DiscoveryConfig setDiscoveryStrategyConfigs(List<DiscoveryStrategyConfig> discoveryStrategyConfigs) {
        this.discoveryStrategyConfigs = discoveryStrategyConfigs == null ? new ArrayList(1) : discoveryStrategyConfigs;
        return this;
    }

    public DiscoveryConfig addDiscoveryStrategyConfig(DiscoveryStrategyConfig discoveryStrategyConfig) {
        this.discoveryStrategyConfigs.add(discoveryStrategyConfig);
        return this;
    }

    public String toString() {
        return "DiscoveryConfig{discoveryStrategyConfigs=" + this.discoveryStrategyConfigs + ", discoveryServiceProvider=" + this.discoveryServiceProvider + ", nodeFilter=" + this.nodeFilter + ", nodeFilterClass='" + this.nodeFilterClass + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryConfig that = (DiscoveryConfig)o;
        return this.discoveryStrategyConfigs.equals(that.discoveryStrategyConfigs) && Objects.equals(this.discoveryServiceProvider, that.discoveryServiceProvider) && Objects.equals(this.nodeFilterClass, that.nodeFilterClass) && Objects.equals(this.nodeFilter, that.nodeFilter);
    }

    public int hashCode() {
        return Objects.hash(this.discoveryStrategyConfigs, this.discoveryServiceProvider, this.nodeFilterClass, this.nodeFilter);
    }
}

