/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DiscoveryStrategyConfig {
    private String className;
    private transient DiscoveryStrategyFactory discoveryStrategyFactory;
    private Map<String, Comparable> properties;

    public DiscoveryStrategyConfig() {
        this.properties = MapUtil.createHashMap(1);
    }

    public DiscoveryStrategyConfig(String className) {
        this(className, Collections.emptyMap());
    }

    public DiscoveryStrategyConfig(String className, Map<String, Comparable> properties) {
        this.className = className;
        this.properties = properties == null ? MapUtil.createHashMap(1) : new HashMap<String, Comparable>(properties);
        this.discoveryStrategyFactory = null;
    }

    public DiscoveryStrategyConfig(DiscoveryStrategyFactory discoveryStrategyFactory) {
        this(discoveryStrategyFactory, Collections.emptyMap());
    }

    public DiscoveryStrategyConfig(DiscoveryStrategyFactory discoveryStrategyFactory, Map<String, Comparable> properties) {
        this.className = null;
        this.properties = properties == null ? MapUtil.createHashMap(1) : new HashMap<String, Comparable>(properties);
        this.discoveryStrategyFactory = discoveryStrategyFactory;
    }

    public DiscoveryStrategyConfig(DiscoveryStrategyConfig config) {
        this.className = config.className;
        this.discoveryStrategyFactory = config.discoveryStrategyFactory;
        this.properties = new HashMap<String, Comparable>(config.properties);
    }

    public String getClassName() {
        return this.className;
    }

    public DiscoveryStrategyConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Discovery strategy factory class name must contain text");
        this.discoveryStrategyFactory = null;
        return this;
    }

    public DiscoveryStrategyConfig setDiscoveryStrategyFactory(@Nonnull DiscoveryStrategyFactory discoveryStrategyFactory) {
        this.discoveryStrategyFactory = Preconditions.checkNotNull(discoveryStrategyFactory, "Discovery strategy factory cannot be null!");
        this.className = null;
        return this;
    }

    public DiscoveryStrategyFactory getDiscoveryStrategyFactory() {
        return this.discoveryStrategyFactory;
    }

    public DiscoveryStrategyConfig addProperty(String key, Comparable value) {
        this.properties.put(key, value);
        return this;
    }

    public DiscoveryStrategyConfig removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public DiscoveryStrategyConfig setProperties(Map<String, Comparable> properties) {
        this.properties = properties == null ? MapUtil.createHashMap(1) : new HashMap<String, Comparable>(properties);
        return this;
    }

    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "DiscoveryStrategyConfig{properties=" + this.properties + ", className='" + this.className + "', discoveryStrategyFactory=" + this.discoveryStrategyFactory + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryStrategyConfig that = (DiscoveryStrategyConfig)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.properties);
    }
}

