/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.NamespacesSupported;
import java.util.EventListener;
import java.util.Objects;
import javax.annotation.Nonnull;

@NamespacesSupported
public class ListenerConfig {
    protected String className;
    protected EventListener implementation;

    public ListenerConfig() {
    }

    public ListenerConfig(String className) {
        this.setClassName(className);
    }

    public ListenerConfig(EventListener implementation) {
        this.setImplementation(implementation);
    }

    public ListenerConfig(ListenerConfig config) {
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
    }

    public String getClassName() {
        return this.className;
    }

    public ListenerConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Event listener class name must contain text");
        this.implementation = null;
        return this;
    }

    public EventListener getImplementation() {
        return this.implementation;
    }

    public ListenerConfig setImplementation(EventListener implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Event listener cannot be null!");
        this.className = null;
        return this;
    }

    public boolean isIncludeValue() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    public String toString() {
        return "ListenerConfig [className=" + this.className + ", implementation=" + this.implementation + ", includeValue=" + this.isIncludeValue() + ", local=" + this.isLocal() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListenerConfig that = (ListenerConfig)o;
        return Objects.equals(this.implementation, that.implementation) && Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.implementation, this.className);
    }
}

