/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class SocketInterceptorConfig {
    private boolean enabled;
    private String className;
    private Object implementation;
    private Properties properties;

    public SocketInterceptorConfig() {
        this.properties = new Properties();
    }

    public SocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.enabled = socketInterceptorConfig.enabled;
        this.className = socketInterceptorConfig.className;
        this.implementation = socketInterceptorConfig.implementation;
        this.properties = PropertiesUtil.clone(socketInterceptorConfig.properties);
    }

    public String getClassName() {
        return this.className;
    }

    public SocketInterceptorConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Socket interceptor class name must contain text");
        this.implementation = null;
        return this;
    }

    public SocketInterceptorConfig setImplementation(@Nonnull Object implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Socket interceptor cannot be null!");
        this.className = null;
        return this;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SocketInterceptorConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SocketInterceptorConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SocketInterceptorConfig setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        this.properties = properties;
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SocketInterceptorConfig)) {
            return false;
        }
        SocketInterceptorConfig that = (SocketInterceptorConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.className, that.className) && Objects.equals(this.properties, that.properties);
    }

    public final int hashCode() {
        return Objects.hash(this.enabled, this.implementation, this.className, this.properties);
    }

    public String toString() {
        return "SocketInterceptorConfig{className='" + this.className + "', enabled=" + this.enabled + ", implementation=" + this.implementation + ", properties=" + this.properties + "}";
    }
}

