/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AuthenticationConfig;
import com.hazelcast.config.security.CredentialsIdentityConfig;
import com.hazelcast.config.security.DefaultAuthenticationConfig;
import com.hazelcast.config.security.IdentityConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import java.util.Objects;

public class RealmConfig {
    private AuthenticationConfig authenticationConfig = DefaultAuthenticationConfig.INSTANCE;
    private IdentityConfig identityConfig;

    public JaasAuthenticationConfig getJaasAuthenticationConfig() {
        return this.getIfType(this.authenticationConfig, JaasAuthenticationConfig.class);
    }

    public RealmConfig setJaasAuthenticationConfig(JaasAuthenticationConfig authenticationConfig) {
        this.authenticationConfig = Objects.requireNonNull(authenticationConfig, "Authentication config can't be null");
        return this;
    }

    public TokenIdentityConfig getTokenIdentityConfig() {
        return this.getIfType(this.identityConfig, TokenIdentityConfig.class);
    }

    public RealmConfig setCredentials(Credentials credentials) {
        this.identityConfig = new CredentialsIdentityConfig(credentials);
        return this;
    }

    public boolean isAuthenticationConfigured() {
        return this.authenticationConfig != null && this.authenticationConfig != DefaultAuthenticationConfig.INSTANCE;
    }

    public LoginModuleConfig[] asLoginModuleConfigs() {
        return this.authenticationConfig.asLoginModuleConfigs();
    }

    public ICredentialsFactory asCredentialsFactory() {
        return this.identityConfig != null ? this.identityConfig.asCredentialsFactory(null) : null;
    }

    public int hashCode() {
        return Objects.hash(this.authenticationConfig, this.identityConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealmConfig other = (RealmConfig)obj;
        return Objects.equals(this.authenticationConfig, other.authenticationConfig) && Objects.equals(this.identityConfig, other.identityConfig);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RealmConfig [authenticationConfig=").append(this.authenticationConfig).append(", identityConfig=").append(this.identityConfig).append("]");
        return builder.toString();
    }

    private <T> T getIfType(Object inst, Class<T> clazz) {
        return clazz.isInstance(inst) ? (T)clazz.cast(inst) : null;
    }
}

