/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleAuthenticationConfig
extends AbstractClusterLoginConfig<SimpleAuthenticationConfig> {
    private final Map<String, UserDto> userMap = new ConcurrentHashMap<String, UserDto>();
    private volatile String roleSeparator;

    public SimpleAuthenticationConfig addUser(@Nonnull String username, @Nonnull String password, String ... roles) {
        this.addUser(username, new UserDto(password, roles));
        return this.self();
    }

    public SimpleAuthenticationConfig addUser(@Nonnull String username, @Nonnull UserDto userDto) {
        Objects.requireNonNull(userDto, "UserDto object has to be provided");
        this.userMap.compute(Objects.requireNonNull(username), (u, dto) -> {
            if (dto != null) {
                throw new IllegalArgumentException("User " + username + " already exists.");
            }
            return userDto;
        });
        return this.self();
    }

    public SimpleAuthenticationConfig setRoleSeparator(@Nullable String roleSeparator) {
        if (roleSeparator != null && roleSeparator.isEmpty()) {
            throw new IllegalArgumentException("Empty role separator is not allowed");
        }
        this.roleSeparator = roleSeparator;
        return this.self();
    }

    @Nullable
    public String getRoleSeparator() {
        return this.roleSeparator;
    }

    @Nonnull
    public Set<String> getUsernames() {
        return new HashSet<String>(this.userMap.keySet());
    }

    public String getPassword(@Nonnull String username) {
        UserDto user = this.userMap.get(Objects.requireNonNull(username, "Username has to be provided"));
        return user == null ? null : user.password;
    }

    public Set<String> getRoles(@Nonnull String username) {
        UserDto user = this.userMap.get(Objects.requireNonNull(username, "Username has to be provided"));
        return user == null ? null : new HashSet<String>(user.roles);
    }

    public SimpleAuthenticationConfig setUserMap(@Nullable Map<String, UserDto> map) {
        this.userMap.clear();
        if (map != null) {
            this.userMap.putAll(map);
        }
        return this.self();
    }

    @Override
    protected Properties initLoginModuleProperties() {
        Properties props = super.initLoginModuleProperties();
        this.setIfConfigured(props, "roleSeparator", this.roleSeparator);
        String rs = this.roleSeparator != null ? this.roleSeparator : ",";
        for (Map.Entry<String, UserDto> entry : this.userMap.entrySet()) {
            String name = entry.getKey();
            UserDto user = entry.getValue();
            this.setIfConfigured(props, "password." + name, user.password);
            this.setIfConfigured(props, "roles." + name, user.roles.stream().collect(Collectors.joining(rs)));
        }
        return props;
    }

    @Override
    public LoginModuleConfig[] asLoginModuleConfigs() {
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig("com.hazelcast.security.loginimpl.SimplePropertiesLoginModule", LoginModuleConfig.LoginModuleUsage.REQUIRED);
        loginModuleConfig.setProperties(this.initLoginModuleProperties());
        return new LoginModuleConfig[]{loginModuleConfig};
    }

    public String toString() {
        return "SimpleAuthenticationConfig [userMap=" + this.userMap + ", roleSeparator=" + this.roleSeparator + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.roleSeparator, this.userMap);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SimpleAuthenticationConfig other = (SimpleAuthenticationConfig)obj;
        return Objects.equals(this.roleSeparator, other.roleSeparator) && Objects.equals(this.userMap, other.userMap);
    }

    @Override
    protected SimpleAuthenticationConfig self() {
        return this;
    }

    protected static String requireNonEmpty(String str, String message) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static class UserDto {
        final String password;
        final Set<String> roles;

        public UserDto(@Nonnull String password, String ... roles) {
            this.password = SimpleAuthenticationConfig.requireNonEmpty(password, "Password can't be empty");
            Objects.requireNonNull(roles, "Roles can't be null");
            this.roles = Collections.unmodifiableSet(Arrays.stream(roles).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new ConcurrentHashMap()))));
        }

        public String toString() {
            return "{password=***, roles=" + this.roles + "}";
        }

        public int hashCode() {
            return Objects.hash(this.password, this.roles);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UserDto other = (UserDto)obj;
            return Objects.equals(this.password, other.password) && Objects.equals(this.roles, other.roles);
        }
    }
}

