/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.AbstractClusterLoginConfig;
import java.util.Objects;
import java.util.Properties;

public class TlsAuthenticationConfig
extends AbstractClusterLoginConfig<TlsAuthenticationConfig> {
    private String roleAttribute;

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public TlsAuthenticationConfig setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
        return this;
    }

    @Override
    protected Properties initLoginModuleProperties() {
        Properties props = super.initLoginModuleProperties();
        this.setIfConfigured(props, "roleAttribute", this.roleAttribute);
        return props;
    }

    @Override
    public LoginModuleConfig[] asLoginModuleConfigs() {
        LoginModuleConfig loginModuleConfig = new LoginModuleConfig("com.hazelcast.security.loginimpl.X509CertificateLoginModule", LoginModuleConfig.LoginModuleUsage.REQUIRED);
        loginModuleConfig.setProperties(this.initLoginModuleProperties());
        return new LoginModuleConfig[]{loginModuleConfig};
    }

    public String toString() {
        return "TlsAuthenticationConfig [roleAttribute=" + this.roleAttribute + ", getSkipIdentity()=" + this.getSkipIdentity() + ", getSkipEndpoint()=" + this.getSkipEndpoint() + ", getSkipRole()=" + this.getSkipRole() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.roleAttribute);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TlsAuthenticationConfig other = (TlsAuthenticationConfig)obj;
        return Objects.equals(this.roleAttribute, other.roleAttribute);
    }

    @Override
    protected TlsAuthenticationConfig self() {
        return this;
    }
}

