/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.core.IndeterminateOperationState;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.version.MemberVersion;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

public class MemberLeftException
extends ExecutionException
implements RetryableException,
IndeterminateOperationState {
    private transient Member member;

    public MemberLeftException() {
    }

    public MemberLeftException(String message) {
        super(message);
    }

    public MemberLeftException(Member member) {
        super(member + " has left cluster!");
        this.member = member;
    }

    public MemberLeftException(Throwable cause) {
        super(cause);
    }

    public Member getMember() {
        return this.member;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.checkMember();
        MemberVersion memberVersion = this.member.getVersion() != null ? this.member.getVersion() : MemberVersion.UNKNOWN;
        Address address = this.member.getAddress();
        String host = address.getHost();
        int port = address.getPort();
        UUIDSerializationUtil.writeUUID(out, this.member.getUuid());
        out.writeUTF(host);
        out.writeInt(port);
        out.writeBoolean(this.member.isLiteMember());
        out.writeObject(memberVersion);
    }

    private void checkMember() {
        if (this.member == null) {
            throw new IllegalArgumentException("member is null");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        UUID uuid = UUIDSerializationUtil.readUUID(in);
        String host = in.readUTF();
        int port = in.readInt();
        boolean liteMember = in.readBoolean();
        MemberVersion version = (MemberVersion)in.readObject();
        this.member = new MemberImpl.Builder(new Address(host, port)).version(version).uuid(uuid).liteMember(liteMember).build();
    }
}

