/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.util.EmptyStatement;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public final class ConfigLoader {
    private static final String CLASSPATH_PREFIX = "classpath:";

    private ConfigLoader() {
    }

    public static URL locateConfig(String path) {
        if (path.isEmpty()) {
            return null;
        }
        URL url = ConfigLoader.asFile(path);
        if (url == null) {
            url = ConfigLoader.asURL(path);
        }
        if (url == null) {
            url = ConfigLoader.asResource(path);
        }
        if (url == null) {
            String extractedPath = ConfigLoader.extractPathOrNull(path);
            if (extractedPath == null) {
                return null;
            }
            url = ConfigLoader.asResource(extractedPath);
        }
        return url;
    }

    private static String extractPathOrNull(String path) {
        if (path.startsWith(CLASSPATH_PREFIX)) {
            return path.substring(CLASSPATH_PREFIX.length());
        }
        return null;
    }

    private static URL asFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        return null;
    }

    private static URL asURL(String path) {
        try {
            return URI.create(OS.ensureUnixSeparators(path)).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException ignored) {
            EmptyStatement.ignore(ignored);
            return null;
        }
    }

    private static URL asResource(String path) {
        URL url = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(path);
        }
        if (url == null) {
            url = ConfigLoader.class.getClassLoader().getResource(path);
        }
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource(path);
        }
        return url;
    }
}

