/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import java.util.EnumSet;
import java.util.Set;

public final class ConfigValidator {
    private static final Set<MaxSizePolicy> NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES = EnumSet.of(MaxSizePolicy.ENTRY_COUNT);

    private ConfigValidator() {
    }

    public static void checkNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig) {
        ConfigValidator.checkNotNativeWhenOpenSource(nearCacheConfig.getInMemoryFormat());
        ConfigValidator.checkLocalUpdatePolicy(mapName, nearCacheConfig.getLocalUpdatePolicy());
        EvictionConfig evictionConfig = nearCacheConfig.getEvictionConfig();
        ConfigValidator.checkNearCacheEvictionConfig(evictionConfig.getEvictionPolicy(), evictionConfig.getComparatorClassName(), evictionConfig.getComparator());
        ConfigValidator.checkOnHeapNearCacheMaxSizePolicy(nearCacheConfig);
        ConfigValidator.checkNearCacheNativeMemoryConfig(nearCacheConfig.getInMemoryFormat(), nativeMemoryConfig, BuildInfoProvider.getBuildInfo().isEnterprise());
        if (nearCacheConfig.isCacheLocalEntries()) {
            throw new InvalidConfigurationException("The Near Cache option `cache-local-entries` is not supported in client configurations.");
        }
    }

    private static void checkLocalUpdatePolicy(String mapName, NearCacheConfig.LocalUpdatePolicy localUpdatePolicy) {
        if (localUpdatePolicy != NearCacheConfig.LocalUpdatePolicy.INVALIDATE) {
            throw new InvalidConfigurationException(String.format("Wrong `local-update-policy` option is selected for `%s` map Near Cache. Only `%s` option is supported but found `%s`", new Object[]{mapName, NearCacheConfig.LocalUpdatePolicy.INVALIDATE, localUpdatePolicy}));
        }
    }

    public static void checkEvictionConfig(EvictionConfig evictionConfig, Set<EvictionPolicy> supportedEvictionPolicies) {
        if (evictionConfig == null) {
            throw new InvalidConfigurationException("Eviction config cannot be null!");
        }
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, supportedEvictionPolicies);
    }

    private static void checkOnHeapNearCacheMaxSizePolicy(NearCacheConfig nearCacheConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return;
        }
        MaxSizePolicy maxSizePolicy = nearCacheConfig.getEvictionConfig().getMaxSizePolicy();
        if (!NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES.contains((Object)maxSizePolicy)) {
            throw new InvalidConfigurationException(String.format("Near Cache maximum size policy %s cannot be used with %s storage. Supported maximum size policies are: %s", new Object[]{maxSizePolicy, inMemoryFormat, NEAR_CACHE_SUPPORTED_ON_HEAP_MAX_SIZE_POLICIES}));
        }
    }

    static void checkNearCacheNativeMemoryConfig(InMemoryFormat inMemoryFormat, NativeMemoryConfig nativeMemoryConfig, boolean isEnterprise) {
        if (!isEnterprise) {
            return;
        }
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return;
        }
        if (nativeMemoryConfig != null && nativeMemoryConfig.isEnabled()) {
            return;
        }
        throw new InvalidConfigurationException("Enable native memory config to use NATIVE in-memory-format for Near Cache");
    }

    public static void checkEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, Set<EvictionPolicy> supportedEvictionPolicies) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        if (!supportedEvictionPolicies.contains((Object)evictionPolicy)) {
            if (StringUtil.isNullOrEmpty(comparatorClassName) && comparator == null) {
                String msg = String.format("Eviction policy `%s` is not supported. Either you can provide a custom one or you can use a supported one: %s.", new Object[]{evictionPolicy, supportedEvictionPolicies});
                throw new InvalidConfigurationException(msg);
            }
        } else {
            ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
        }
    }

    private static void checkComparatorDefinedOnlyOnce(String comparatorClassName, Object comparator) {
        if (comparatorClassName != null && comparator != null) {
            throw new InvalidConfigurationException("Only one of the `comparator class name` and `comparator` can be configured in the eviction configuration!");
        }
    }

    public static void checkNearCacheEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator) {
        ConfigValidator.checkComparatorDefinedOnlyOnce(comparatorClassName, comparator);
        ConfigValidator.checkEvictionPolicyConfiguredOnlyOnce(evictionPolicy, comparatorClassName, comparator, EvictionConfig.DEFAULT_EVICTION_POLICY);
    }

    private static void checkEvictionPolicyConfiguredOnlyOnce(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, EvictionPolicy defaultEvictionPolicy) {
        if (evictionPolicy != defaultEvictionPolicy) {
            if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator class name` can be configured!");
            }
            if (comparator != null) {
                throw new InvalidConfigurationException("Only one of the `eviction policy` and `comparator` can be configured!");
            }
        }
    }

    private static void checkNotNativeWhenOpenSource(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new InvalidConfigurationException("NATIVE storage format is supported in Hazelcast Enterprise only. Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
    }
}

