/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DeclarativeConfigUtil {
    public static final String SYSPROP_CLIENT_CONFIG = "hazelcast.client.config";
    public static final String SYSPROP_CLIENT_FAILOVER_CONFIG = "hazelcast.client.failover.config";
    public static final Collection<String> XML_ACCEPTED_SUFFIXES = Collections.singletonList("xml");
    public static final String XML_ACCEPTED_SUFFIXES_STRING = Arrays.toString(XML_ACCEPTED_SUFFIXES.toArray());
    public static final Collection<String> YAML_ACCEPTED_SUFFIXES = List.of("yaml", "yml");
    public static final String YAML_ACCEPTED_SUFFIXES_STRING = Arrays.toString(YAML_ACCEPTED_SUFFIXES.toArray());
    public static final Collection<String> ALL_ACCEPTED_SUFFIXES = List.of("xml", "yaml", "yml");
    public static final String ALL_ACCEPTED_SUFFIXES_STRING = Arrays.toString(ALL_ACCEPTED_SUFFIXES.toArray());

    private DeclarativeConfigUtil() {
    }

    public static void validateSuffixInSystemProperty(String propertyKey) {
        String configSystemProperty = System.getProperty(propertyKey);
        if (configSystemProperty == null) {
            return;
        }
        if (!DeclarativeConfigUtil.isAcceptedSuffixConfigured(configSystemProperty, ALL_ACCEPTED_SUFFIXES)) {
            DeclarativeConfigUtil.throwUnacceptedSuffixInSystemProperty(propertyKey, configSystemProperty, ALL_ACCEPTED_SUFFIXES);
        }
    }

    public static void throwUnacceptedSuffixInSystemProperty(String propertyKey, String configResource, Collection<String> acceptedSuffixes) {
        String message = String.format("The suffix of the resource '%s' referenced in '%s' is not in the list of accepted suffixes: '%s'", configResource, propertyKey, Arrays.toString(acceptedSuffixes.toArray()));
        throw new HazelcastException(message);
    }

    public static boolean isAcceptedSuffixConfigured(String configFile, Collection<String> acceptedSuffixes) {
        String configFileLower = StringUtil.lowerCaseInternal(configFile);
        int lastDotIndex = configFileLower.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return false;
        }
        String configFileSuffix = configFileLower.substring(lastDotIndex + 1);
        return acceptedSuffixes.contains(configFileSuffix);
    }
}

