/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class MetricsConfigHelper {
    private MetricsConfigHelper() {
    }

    public static ProbeLevel clientMetricsLevel(HazelcastProperties properties, ILogger logger) {
        ProbeLevel probeLevel;
        boolean debugMetrics = properties.getBoolean(ClientProperty.METRICS_DEBUG);
        ProbeLevel probeLevel2 = probeLevel = debugMetrics ? ProbeLevel.DEBUG : ProbeLevel.INFO;
        if (probeLevel == ProbeLevel.INFO) {
            logger.fine("Collecting debug metrics and sending to diagnostics is disabled");
        } else {
            logger.info("Collecting debug metrics and sending to diagnostics is enabled");
        }
        return probeLevel;
    }

    public static void overrideClientMetricsConfig(ClientConfig config, ILogger logger) {
        ClientMetricsConfig metricsConfig = config.getMetricsConfig();
        MetricsJmxConfig jmxConfig = metricsConfig.getJmxConfig();
        MetricsConfigHelper.tryOverride(ClientProperty.STATISTICS_PERIOD_SECONDS, config::getProperty, prop -> metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(prop)), () -> Integer.toString(metricsConfig.getCollectionFrequencySeconds()), "ClientMetricsConfig.collectionFrequencySeconds", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.STATISTICS_ENABLED, config::getProperty, prop -> metricsConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(metricsConfig.isEnabled()), "ClientMetricsConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_ENABLED, config::getProperty, prop -> metricsConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(metricsConfig.isEnabled()), "ClientMetricsConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_JMX_ENABLED, config::getProperty, prop -> jmxConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(jmxConfig.isEnabled()), "MetricsJmxConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_COLLECTION_FREQUENCY, config::getProperty, prop -> metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(prop)), () -> Integer.toString(metricsConfig.getCollectionFrequencySeconds()), "ClientMetricsConfig.collectionFrequencySeconds", logger);
    }

    private static void tryOverride(HazelcastProperty property, UnaryOperator<String> getPropertyValueFn, Consumer<String> setterFn, Supplier<String> getterFn, String configOverridden, ILogger logger) {
        String propertyValue = (String)getPropertyValueFn.apply(property.getName());
        try {
            if (propertyValue != null) {
                setterFn.accept(propertyValue);
                logger.info(String.format("Overridden metrics configuration with system property '%s'='%s' -> '%s'='%s'", property, propertyValue, configOverridden, getterFn.get()));
            }
        }
        catch (Exception ex) {
            logger.warning(String.format("Failed to override metrics configuration with system property '%s'='%s'. Kept '%s'='%s'", property.getName(), propertyValue, configOverridden, getterFn.get()), ex);
        }
    }
}

