/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.services;

import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;

@PrivateApi
public final class DistributedObjectNamespace
implements ObjectNamespace,
IdentifiedDataSerializable {
    private String service;
    private String objectName;

    public DistributedObjectNamespace() {
    }

    public DistributedObjectNamespace(String serviceName, String objectName) {
        this.service = serviceName;
        this.objectName = objectName;
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.service);
        out.writeString(this.objectName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.service = in.readString();
        this.objectName = in.readString();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistributedObjectNamespace)) {
            return false;
        }
        DistributedObjectNamespace that = (DistributedObjectNamespace)o;
        if (!this.service.equals(that.service)) {
            return false;
        }
        return this.objectName.equals(that.objectName);
    }

    public int hashCode() {
        int result = this.service.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }

    public String toString() {
        return "DistributedObjectNamespace{service='" + this.service + "', objectName='" + this.objectName + "'}";
    }
}

