/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ConcurrencyUtil {
    public static final Executor CALLER_RUNS = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return "CALLER_RUNS";
        }
    };
    private static final Executor DEFAULT_ASYNC_EXECUTOR;

    private ConcurrencyUtil() {
    }

    public static Executor getDefaultAsyncExecutor() {
        return DEFAULT_ASYNC_EXECUTOR;
    }

    public static <K, V> V getOrPutIfAbsent(ConcurrentMap<K, V> map, K key, ConstructorFunction<K, V> func) {
        Object value = map.get(key);
        if (value == null) {
            value = func.createNew(key);
            V current = map.putIfAbsent(key, value);
            value = current == null ? value : current;
        }
        return value;
    }

    public static <E> void setMax(E obj, AtomicLongFieldUpdater<E> updater, long value) {
        long current;
        do {
            if ((current = updater.get(obj)) < value) continue;
            return;
        } while (!updater.compareAndSet(obj, current, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutSynchronized(ConcurrentMap<K, V> map, K key, ContextMutexFactory contextMutexFactory, ConstructorFunction<K, V> func) {
        if (contextMutexFactory == null) {
            throw new NullPointerException();
        }
        Object value = map.get(key);
        if (value == null) {
            try (ContextMutexFactory.Mutex mutex = contextMutexFactory.mutexFor(key);){
                ContextMutexFactory.Mutex mutex2 = mutex;
                synchronized (mutex2) {
                    value = map.get(key);
                    if (value == null) {
                        value = func.createNew(key);
                        map.put(key, value);
                    }
                }
            }
        }
        return value;
    }

    static {
        Executor asyncExecutor = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : command -> new Thread(command).start();
        DEFAULT_ASYNC_EXECUTOR = asyncExecutor;
    }
}

