/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

@PrivateApi
public class FilteringClassLoader
extends ClassLoader {
    private final List<String> excludePackages;
    private final String enforcedSelfLoadingPackage;
    private final ClassLoader delegatingClassLoader;

    public FilteringClassLoader(List<String> excludePackages, String enforcedSelfLoadingPackage) {
        super(null);
        this.excludePackages = excludePackages;
        this.enforcedSelfLoadingPackage = enforcedSelfLoadingPackage;
        try {
            this.delegatingClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL getResource(String name) {
        return this.checkResourceExcluded(name) ? null : this.delegatingClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.checkResourceExcluded(name) ? Collections.enumeration(Collections.emptyList()) : this.delegatingClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.checkResourceExcluded(name) ? null : this.delegatingClassLoader.getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Preconditions.isNotNull(name, "name");
        this.checkExcluded(name);
        if (this.enforcedSelfLoadingPackage != null && name.startsWith(this.enforcedSelfLoadingPackage)) {
            FilteringClassLoader filteringClassLoader = this;
            synchronized (filteringClassLoader) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz == null) {
                    clazz = this.loadAndDefineClass(name);
                }
                return clazz;
            }
        }
        return this.delegatingClassLoader.loadClass(name);
    }

    public boolean checkResourceExcluded(String resourceName) {
        if (resourceName == null) {
            return true;
        }
        String resourceAsClassName = resourceName.replace('/', '.').replace(".class", "");
        for (String excludedPackage : this.excludePackages) {
            if (!resourceAsClassName.startsWith(excludedPackage)) continue;
            return true;
        }
        return false;
    }

    public void checkExcluded(String name) throws ClassNotFoundException {
        for (String excludedPackage : this.excludePackages) {
            if (!name.startsWith(excludedPackage)) continue;
            throw new ClassNotFoundException(name + " - Package excluded explicitly!");
        }
    }

    private Class<?> loadAndDefineClass(String name) throws ClassNotFoundException {
        try {
            byte[] content = ReflectionUtils.getClassContent(name, this);
            return this.defineClass(name, content, 0, content.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }
}

