/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MapUtil {
    public static final float HASHMAP_DEFAULT_LOAD_FACTOR = 0.75f;

    private MapUtil() {
    }

    public static <K, V> Map<K, V> createHashMap(int expectedMapSize) {
        int initialCapacity = MapUtil.calculateInitialCapacity(expectedMapSize);
        return new HashMap(initialCapacity, 0.75f);
    }

    public static <K, V> Map<K, V> createLinkedHashMap(int expectedMapSize) {
        int initialCapacity = MapUtil.calculateInitialCapacity(expectedMapSize);
        return new LinkedHashMap(initialCapacity, 0.75f);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentHashMap(int expectedMapSize) {
        return new ConcurrentHashMap(expectedMapSize);
    }

    public static int calculateInitialCapacity(int expectedMapSize) {
        return (int)((float)expectedMapSize / 0.75f) + 1;
    }

    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> Map.Entry<K, V> entry(K k, V v) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(k, v);
    }
}

