/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.util.Objects;
import javax.annotation.Nonnull;

public final class Preconditions {
    private Preconditions() {
    }

    public static String checkHasText(String argument, String errorMessage) {
        if (argument == null || argument.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument;
    }

    @Nonnull
    public static <T> T checkNotNull(T argument, String errorMessage) {
        return Objects.requireNonNull(argument, errorMessage);
    }

    public static <T> Iterable<T> checkNoNullInside(Iterable<T> argument, String errorMessage) {
        if (argument == null) {
            return argument;
        }
        for (T element : argument) {
            Objects.requireNonNull(element, errorMessage);
        }
        return argument;
    }

    @Nonnull
    public static <T> T checkNotNull(T argument) {
        return Objects.requireNonNull(argument);
    }

    public static <E> E isNotNull(E argument, String argName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("argument '%s' can't be null", argName));
        }
        return argument;
    }

    public static long checkNotNegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkNotNegative(int value, String errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static long checkPositive(String paramName, long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException(paramName + " is " + value + " but must be > 0");
        }
        return value;
    }

    public static double checkPositive(double value, String errorMessage) {
        if (value <= 0.0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public static int checkPositive(String paramName, int value) {
        if (value <= 0) {
            throw new IllegalArgumentException(paramName + " is " + value + " but must be > 0");
        }
        return value;
    }

    public static void checkFalse(boolean expression, String errorMessage) {
        if (expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkTrue(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static <E> E checkNotInstanceOf(Class type, E object, String errorMessage) {
        Preconditions.isNotNull(type, "type");
        if (type.isInstance(object)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return object;
    }

    public static <E> E checkInstanceOf(Class<E> type, Object object, String errorMessage) {
        Preconditions.isNotNull(type, "type");
        if (!type.isInstance(object)) {
            throw new IllegalArgumentException(errorMessage);
        }
        return (E)object;
    }
}

