/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.IterationType;
import java.util.Comparator;
import java.util.Map;

public final class SortingUtil {
    private SortingUtil() {
    }

    public static int compare(Comparator<Map.Entry> comparator, IterationType iterationType, Map.Entry entry1, Map.Entry entry2) {
        Object comparable1;
        if (comparator != null) {
            int result = comparator.compare(entry1, entry2);
            if (result != 0) {
                return result;
            }
            return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
        }
        Object comparable2 = switch (iterationType) {
            case IterationType.KEY -> {
                comparable1 = entry1.getKey();
                yield entry2.getKey();
            }
            case IterationType.VALUE -> {
                comparable1 = entry1.getValue();
                yield entry2.getValue();
            }
            default -> {
                if (entry1 instanceof Comparable && entry2 instanceof Comparable) {
                    comparable1 = entry1;
                    yield entry2;
                }
                comparable1 = entry1.getKey();
                yield entry2.getKey();
            }
        };
        SortingUtil.checkIfComparable(comparable1);
        SortingUtil.checkIfComparable(comparable2);
        int result = ((Comparable)comparable1).compareTo(comparable2);
        if (result != 0) {
            return result;
        }
        return SortingUtil.compareIntegers(entry1.getKey().hashCode(), entry2.getKey().hashCode());
    }

    private static void checkIfComparable(Object comparable) {
        if (comparable instanceof Comparable) {
            return;
        }
        throw new IllegalArgumentException("Not comparable " + comparable);
    }

    private static int compareIntegers(int i1, int i2) {
        if (i1 > i2) {
            return 1;
        }
        if (i2 > i1) {
            return -1;
        }
        return 0;
    }
}

