/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.tpcengine.util.JVM;
import com.hazelcast.internal.tpcengine.util.OS;
import com.hazelcast.internal.util.CloseUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.BitSet;
import net.openhft.affinity.Affinity;

public final class ThreadAffinityHelper {
    private static final String AFFINITY_LIB_DISABLED = "hazelcast.affinity.lib.disabled";
    private static final ILogger LOGGER = Logger.getLogger(ThreadAffinityHelper.class);
    private static final boolean USE_HZ_LIB;

    private ThreadAffinityHelper() {
    }

    static boolean isAffinityAvailable() {
        if (USE_HZ_LIB) {
            return true;
        }
        try {
            boolean jnaAvailable = Affinity.isJNAAvailable();
            if (!jnaAvailable) {
                LOGGER.warning("JNA is not available");
            }
            return jnaAvailable;
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warning("The OpenHFT Affinity jar isn't available: " + e.getMessage());
            return false;
        }
    }

    public static BitSet getAffinity() {
        try {
            if (USE_HZ_LIB) {
                return ThreadAffinityHelper.getAffinity0();
            }
            return Affinity.getAffinity();
        }
        catch (Exception ex) {
            LOGGER.warning("An error occurred while getting the affinity for the current thread", ex);
            return new BitSet();
        }
    }

    public static void setAffinity(BitSet cpuMask) {
        try {
            if (USE_HZ_LIB) {
                ThreadAffinityHelper.setAffinity0(cpuMask);
            } else {
                Affinity.setAffinity((BitSet)cpuMask);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("An error occurred while setting the affinity for the current thread", ex);
        }
    }

    private static native BitSet getAffinity0();

    private static native void setAffinity0(BitSet var0);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractBundledLib() {
        String string;
        InputStream src = null;
        try {
            src = CloseUtil.class.getClassLoader().getResourceAsStream("lib/linux-x86_64/libaffinity_helper.so");
            File dest = File.createTempFile("hazelcast-libaffinity-helper-", ".so");
            Files.copy(src, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            string = dest.getAbsolutePath();
        }
        catch (Error | RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(src);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(src);
        return string;
    }

    static {
        boolean hzAffinityLibLoaded = false;
        boolean libDisabled = false;
        String libDisabledString = System.getProperty(AFFINITY_LIB_DISABLED);
        if (libDisabledString != null) {
            libDisabled = libDisabledString.equalsIgnoreCase("true");
        }
        if (!libDisabled && OS.isLinux() && !JVM.is32bit()) {
            try {
                System.load(ThreadAffinityHelper.extractBundledLib());
                hzAffinityLibLoaded = true;
            }
            catch (Throwable t) {
                LOGGER.fine("Could not load Hazelcast Linux x86_64 CPU affinity helper native shared library", t);
            }
        }
        USE_HZ_LIB = hzAffinityLibLoaded;
    }
}

