/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> Class<T> loadClass(ClassLoader classLoaderHint, String name) {
        try {
            return ClassLoaderUtil.loadClass(classLoaderHint, name);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> T newInstance(ClassLoader classLoader, String name) {
        try {
            return ClassLoaderUtil.newInstance(classLoader, name);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> T readStaticFieldOrNull(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            return ReflectionUtils.readStaticField(clazz, fieldName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    private static <T> T readStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return (T)field.get(null);
    }

    private static String toPath(String name) {
        return name.replace('.', '/');
    }

    public static String toClassResourceId(String name) {
        return ReflectionUtils.toPath(name) + ".class";
    }

    @Nullable
    public static byte[] getClassContent(String name, ClassLoader classLoader) throws IOException {
        try (InputStream is = classLoader.getResourceAsStream(ReflectionUtils.toClassResourceId(name));){
            if (is == null) {
                throw new IOException("Resource not found");
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    public static <E> E findStaticFieldValue(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getField(fieldName);
            return (E)field.get(null);
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

