/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.BaseMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMap<K, V>
extends ConcurrentMap<K, V>,
BaseMap<K, V>,
Iterable<Map.Entry<K, V>> {
    @Override
    public V put(@Nonnull K var1, @Nonnull V var2);

    @Override
    public V put(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public V put(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    @Override
    public V putIfAbsent(@Nonnull K var1, @Nonnull V var2);

    public V putIfAbsent(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public V putIfAbsent(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    public void putTransient(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public void putTransient(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    public boolean tryPut(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> var1);

    @Override
    public V get(@Nonnull Object var1);

    public Map<K, V> getAll(@Nullable Set<K> var1);

    @Override
    public V remove(@Nonnull Object var1);

    @Override
    public boolean remove(@Nonnull Object var1, @Nonnull Object var2);

    public void removeAll(@Nonnull Predicate<K, V> var1);

    public boolean tryRemove(@Nonnull K var1, long var2, @Nonnull TimeUnit var4);

    @Override
    public void delete(@Nonnull Object var1);

    @Override
    public V replace(@Nonnull K var1, @Nonnull V var2);

    @Override
    public boolean replace(@Nonnull K var1, @Nonnull V var2, @Nonnull V var3);

    @Override
    public boolean containsKey(@Nonnull Object var1);

    @Override
    public boolean containsValue(@Nonnull Object var1);

    @Override
    public void clear();

    @Override
    @Nonnull
    public Set<K> keySet();

    @Override
    public Set<K> keySet(Predicate<K, V> var1);

    @Override
    public Collection<V> values(Predicate<K, V> var1);

    @Override
    @Nonnull
    public Collection<V> values();

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet();

    public Set<Map.Entry<K, V>> entrySet(@Nonnull Predicate<K, V> var1);

    @Override
    default public void replaceAll(@Nonnull BiFunction<? super K, ? super V, ? extends V> function) {
        ConcurrentMap.super.replaceAll(function);
    }

    @Override
    public void set(@Nonnull K var1, @Nonnull V var2);

    public void set(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public void set(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    public void setAll(@Nonnull Map<? extends K, ? extends V> var1);

    public <R> R executeOnKey(@Nonnull K var1, @Nonnull EntryProcessor<K, V, R> var2);

    public <R> Map<K, R> executeOnKeys(@Nonnull Set<K> var1, @Nonnull EntryProcessor<K, V, R> var2);

    public <R> CompletionStage<Map<K, R>> submitToKeys(@Nonnull Set<K> var1, @Nonnull EntryProcessor<K, V, R> var2);

    public <R> CompletionStage<R> submitToKey(@Nonnull K var1, @Nonnull EntryProcessor<K, V, R> var2);

    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> var1);

    public <R> Map<K, R> executeOnEntries(@Nonnull EntryProcessor<K, V, R> var1, @Nonnull Predicate<K, V> var2);

    @Override
    public V compute(@Nonnull K var1, @Nonnull BiFunction<? super K, ? super V, ? extends V> var2);

    @Override
    public V computeIfAbsent(@Nonnull K var1, @Nonnull Function<? super K, ? extends V> var2);

    @Override
    public V computeIfPresent(@Nonnull K var1, @Nonnull BiFunction<? super K, ? super V, ? extends V> var2);

    @Override
    public V merge(@Nonnull K var1, @Nonnull V var2, @Nonnull BiFunction<? super V, ? super V, ? extends V> var3);

    @Override
    @Nonnull
    public Iterator<Map.Entry<K, V>> iterator();

    @Nonnull
    public Iterator<Map.Entry<K, V>> iterator(int var1);

    @Override
    default public void forEach(@Nonnull BiConsumer<? super K, ? super V> action) {
        ConcurrentMap.super.forEach(action);
    }

    public EntryView<K, V> getEntryView(@Nonnull K var1);

    public CompletionStage<V> getAsync(@Nonnull K var1);

    public CompletionStage<V> putAsync(@Nonnull K var1, @Nonnull V var2);

    public CompletionStage<V> putAsync(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public CompletionStage<V> putAsync(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    public CompletionStage<Void> putAllAsync(@Nonnull Map<? extends K, ? extends V> var1);

    public CompletionStage<Void> setAsync(@Nonnull K var1, @Nonnull V var2);

    public CompletionStage<Void> setAsync(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5);

    public CompletionStage<Void> setAsync(@Nonnull K var1, @Nonnull V var2, long var3, @Nonnull TimeUnit var5, long var6, @Nonnull TimeUnit var8);

    public CompletionStage<Void> setAllAsync(@Nonnull Map<? extends K, ? extends V> var1);

    public CompletionStage<V> removeAsync(@Nonnull K var1);

    public CompletionStage<Boolean> deleteAsync(@Nonnull K var1);

    public void lock(@Nonnull K var1);

    public void lock(@Nonnull K var1, long var2, @Nullable TimeUnit var4);

    public boolean tryLock(@Nonnull K var1);

    public boolean tryLock(@Nonnull K var1, long var2, @Nullable TimeUnit var4) throws InterruptedException;

    public boolean tryLock(@Nonnull K var1, long var2, @Nullable TimeUnit var4, long var5, @Nullable TimeUnit var7) throws InterruptedException;

    public void unlock(@Nonnull K var1);

    public void forceUnlock(@Nonnull K var1);

    public boolean isLocked(@Nonnull K var1);

    public boolean evict(@Nonnull K var1);

    public void evictAll();

    public LocalMapStats getLocalMapStats();

    public boolean setTtl(@Nonnull K var1, long var2, @Nonnull TimeUnit var4);

    public void flush();

    public void loadAll(boolean var1);

    public void loadAll(@Nonnull Set<K> var1, boolean var2);

    default public void addIndex(IndexType type, String ... attributes) {
        IndexConfig config = IndexUtils.createIndexConfig(type, attributes);
        this.addIndex(config);
    }

    public void addIndex(IndexConfig var1);

    public String addInterceptor(@Nonnull MapInterceptor var1);

    public boolean removeInterceptor(@Nonnull String var1);

    public UUID addEntryListener(@Nonnull MapListener var1, boolean var2);

    public UUID addEntryListener(@Nonnull MapListener var1, @Nonnull K var2, boolean var3);

    public UUID addEntryListener(@Nonnull MapListener var1, @Nonnull Predicate<K, V> var2, boolean var3);

    public UUID addEntryListener(@Nonnull MapListener var1, @Nonnull Predicate<K, V> var2, @Nullable K var3, boolean var4);

    public boolean removeEntryListener(@Nonnull UUID var1);

    public UUID addPartitionLostListener(@Nonnull MapPartitionLostListener var1);

    public boolean removePartitionLostListener(@Nonnull UUID var1);

    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> var1);

    public <R> R aggregate(@Nonnull Aggregator<? super Map.Entry<K, V>, R> var1, @Nonnull Predicate<K, V> var2);

    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> var1);

    public <R> Collection<R> project(@Nonnull Projection<? super Map.Entry<K, V>, R> var1, @Nonnull Predicate<K, V> var2);
}

