/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Map;

public class AggregationResult
implements Result<AggregationResult> {
    private Aggregator aggregator;
    private PartitionIdSet partitionIds;
    private final transient SerializationService serializationService;

    public AggregationResult() {
        this.serializationService = null;
    }

    public AggregationResult(Aggregator aggregator, SerializationService serializationService) {
        this.aggregator = aggregator;
        this.serializationService = serializationService;
    }

    public <R> Aggregator<?, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    public PartitionIdSet getPartitionIds() {
        return this.partitionIds;
    }

    @Override
    public void combine(AggregationResult result) {
        PartitionIdSet otherPartitionIds = result.getPartitionIds();
        if (otherPartitionIds == null) {
            return;
        }
        if (this.partitionIds == null) {
            this.partitionIds = new PartitionIdSet(otherPartitionIds);
        } else {
            this.partitionIds.addAll(otherPartitionIds);
        }
        this.aggregator.combine(result.aggregator);
    }

    @Override
    public void onCombineFinished() {
        if (this.aggregator != null) {
            this.aggregator.onCombinationFinished();
        }
    }

    @Override
    public void add(QueryableEntry entry) {
        this.aggregator.accumulate(entry);
    }

    @Override
    public AggregationResult createSubResult() {
        Aggregator aggregatorClone = (Aggregator)this.serializationService.toObject(this.serializationService.toData(this.aggregator));
        return new AggregationResult(aggregatorClone, this.serializationService);
    }

    @Override
    public void orderAndLimit(PagingPredicate pagingPredicate, Map.Entry<Integer, Map.Entry> nearestAnchorEntry) {
    }

    @Override
    public void completeConstruction(PartitionIdSet partitionIds) {
        this.setPartitionIds(partitionIds);
    }

    @Override
    public void setPartitionIds(PartitionIdSet partitionIds) {
        this.partitionIds = new PartitionIdSet(partitionIds);
    }
}

