/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.memory;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.memory.MemoryUnit;

public class Capacity {
    private static final int PRETTY_FORMAT_LIMIT = 10;
    private final long value;
    private final MemoryUnit unit;

    public Capacity(long value) {
        this(value, MemoryUnit.BYTES);
    }

    public Capacity(long value, MemoryUnit unit) {
        if (value < 0L) {
            throw new IllegalArgumentException("Capacity cannot be negative! -> " + value);
        }
        this.value = value;
        this.unit = Preconditions.checkNotNull(unit, "MemoryUnit is required!");
    }

    public long getValue() {
        return this.value;
    }

    public MemoryUnit getUnit() {
        return this.unit;
    }

    public long bytes() {
        return this.unit.toBytes(this.value);
    }

    public long kiloBytes() {
        return this.unit.toKiloBytes(this.value);
    }

    public long megaBytes() {
        return this.unit.toMegaBytes(this.value);
    }

    public long gigaBytes() {
        return this.unit.toGigaBytes(this.value);
    }

    public static Capacity of(long value, MemoryUnit unit) {
        return new Capacity(value, unit);
    }

    public static Capacity parse(String value) {
        return Capacity.parse(value, MemoryUnit.BYTES);
    }

    public static Capacity parse(String value, MemoryUnit defaultUnit) {
        if (value == null || value.length() == 0) {
            return new Capacity(0L, MemoryUnit.BYTES);
        }
        MemoryUnit unit = defaultUnit;
        char last = value.charAt(value.length() - 1);
        if (!Character.isDigit(last)) {
            value = value.substring(0, value.length() - 1);
            switch (last) {
                case 'G': 
                case 'g': {
                    unit = MemoryUnit.GIGABYTES;
                    break;
                }
                case 'M': 
                case 'm': {
                    unit = MemoryUnit.MEGABYTES;
                    break;
                }
                case 'K': 
                case 'k': {
                    unit = MemoryUnit.KILOBYTES;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Could not determine memory unit of " + value + last);
                }
            }
        }
        return new Capacity(Long.parseLong(value), unit);
    }

    public String toPrettyString() {
        return Capacity.toPrettyString(this.value, this.unit);
    }

    public final String toString() {
        return this.value + " " + this.unit.toString();
    }

    public static String toPrettyString(long capacity) {
        return Capacity.toPrettyString(capacity, MemoryUnit.BYTES);
    }

    public static String toPrettyString(long capacity, MemoryUnit unit) {
        if (unit.toGigaBytes(capacity) >= 10L) {
            return unit.toGigaBytes(capacity) + " GB";
        }
        if (unit.toMegaBytes(capacity) >= 10L) {
            return unit.toMegaBytes(capacity) + " MB";
        }
        if (unit.toKiloBytes(capacity) >= 10L) {
            return unit.toKiloBytes(capacity) + " KB";
        }
        if (capacity % 1024L == 0L) {
            return unit.toKiloBytes(capacity) + " KB";
        }
        return unit.toBytes(capacity) + " bytes";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capacity)) {
            return false;
        }
        Capacity that = (Capacity)o;
        if (this.value != that.value) {
            return false;
        }
        return this.unit == that.unit;
    }

    public final int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }
}

