/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.QueryableEntry;
import java.io.IOException;

public class CachedQueryEntry<K, V>
extends QueryableEntry<K, V>
implements IdentifiedDataSerializable {
    protected Data keyData;
    protected Data valueData;
    protected K keyObject;
    protected V valueObject;

    public CachedQueryEntry() {
    }

    public CachedQueryEntry(SerializationService ss, Object key, Object value) {
        this.init(ss, key, value);
    }

    public CachedQueryEntry<K, V> init(SerializationService ss, Object key, Object value) {
        this.serializationService = (InternalSerializationService)ss;
        return this.init(key, value);
    }

    public CachedQueryEntry<K, V> init(Object key, Object value) {
        Data data;
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        if (key instanceof Data) {
            this.keyData = data = (Data)key;
            this.keyObject = null;
        } else {
            this.keyObject = key;
            this.keyData = null;
        }
        if (value instanceof Data) {
            this.valueData = data = (Data)value;
            this.valueObject = null;
        } else {
            this.valueObject = value;
            this.valueData = null;
        }
        return this;
    }

    public CachedQueryEntry<K, V> initWithObjectKeyValue(Object key, Object value) {
        this.keyObject = key;
        this.keyData = null;
        this.valueObject = value;
        this.valueData = null;
        return this;
    }

    @Override
    public K getKey() {
        if (this.keyObject == null) {
            this.keyObject = this.serializationService.toObject(this.keyData);
        }
        return this.keyObject;
    }

    @Override
    public Data getKeyData() {
        return this.keyData;
    }

    @Override
    public V getValue() {
        if (this.valueObject == null) {
            this.valueObject = this.serializationService.toObject(this.valueData);
        }
        return this.valueObject;
    }

    @Override
    public Data getValueData() {
        if (this.valueData == null) {
            this.valueData = this.serializationService.toData(this.valueObject);
        }
        return this.valueData;
    }

    @Override
    public K getKeyIfPresent() {
        return this.keyObject != null ? (K)this.keyObject : null;
    }

    @Override
    public Data getKeyDataIfPresent() {
        return this.keyData;
    }

    @Override
    public V getValueIfPresent() {
        if (this.valueObject != null) {
            return this.valueObject;
        }
        return null;
    }

    @Override
    public Data getValueDataIfPresent() {
        if (this.valueData != null) {
            return this.valueData;
        }
        return null;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedQueryEntry that = (CachedQueryEntry)o;
        return this.keyData.equals(that.keyData);
    }

    @Override
    public int hashCode() {
        return this.keyData.hashCode();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.getKey());
        out.writeObject(this.getValue());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.keyObject = in.readObject();
        this.valueObject = in.readObject();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 120;
    }
}

