/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.BTreeIndexConfig;
import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class IndexUtils {
    public static final int MAX_ATTRIBUTES = 255;
    private static final Pattern THIS_PATTERN = Pattern.compile("^this\\.");

    private IndexUtils() {
    }

    public static IndexConfig validateAndNormalize(String mapName, IndexConfig config) {
        assert (config != null);
        List<String> originalAttributeNames = config.getAttributes();
        if (originalAttributeNames.isEmpty()) {
            throw new IllegalArgumentException("Index must have at least one attribute: " + config);
        }
        if (originalAttributeNames.size() > 255) {
            throw new IllegalArgumentException("Index cannot have more than 255 attributes: " + config);
        }
        if (config.getType() == IndexType.BITMAP && originalAttributeNames.size() > 1) {
            throw new IllegalArgumentException("Composite bitmap indexes are not supported: " + config);
        }
        ArrayList<String> normalizedAttributeNames = new ArrayList<String>(originalAttributeNames.size());
        for (String originalAttributeName : originalAttributeNames) {
            IndexUtils.validateAttribute(config, originalAttributeName);
            originalAttributeName = originalAttributeName.trim();
            String normalizedAttributeName = IndexUtils.canonicalizeAttribute(originalAttributeName);
            assert (!normalizedAttributeName.isEmpty());
            int existingIdx = normalizedAttributeNames.indexOf(normalizedAttributeName);
            if (existingIdx != -1) {
                String duplicateOriginalAttributeName = originalAttributeNames.get(existingIdx);
                if (duplicateOriginalAttributeName.equals(originalAttributeName)) {
                    throw new IllegalArgumentException("Duplicate attribute name [attributeName=" + originalAttributeName + ", indexConfig=" + config + "]");
                }
                throw new IllegalArgumentException("Duplicate attribute names [attributeName1=" + duplicateOriginalAttributeName + ", attributeName2=" + originalAttributeName + ", indexConfig=" + config + "]");
            }
            normalizedAttributeNames.add(normalizedAttributeName);
        }
        String name = config.getName();
        if (StringUtil.isNullOrEmptyAfterTrim(name)) {
            name = null;
        }
        IndexConfig normalizedConfig = IndexUtils.buildNormalizedConfig(mapName, config.getType(), name, normalizedAttributeNames, config.getBTreeIndexConfig());
        if (config.getType() == IndexType.BITMAP) {
            String uniqueKey = config.getBitmapIndexOptions().getUniqueKey();
            BitmapIndexOptions.UniqueKeyTransformation uniqueKeyTransformation = config.getBitmapIndexOptions().getUniqueKeyTransformation();
            IndexUtils.validateAttribute(uniqueKey);
            uniqueKey = IndexUtils.canonicalizeAttribute(uniqueKey);
            normalizedConfig.getBitmapIndexOptions().setUniqueKey(uniqueKey).setUniqueKeyTransformation(uniqueKeyTransformation);
        }
        return normalizedConfig;
    }

    private static IndexConfig buildNormalizedConfig(String mapName, IndexType indexType, String indexName, List<String> normalizedAttributeNames, BTreeIndexConfig btreeIndexConfig) {
        IndexConfig newConfig = new IndexConfig().setType(indexType);
        StringBuilder nameBuilder = indexName == null ? new StringBuilder(mapName + "_" + IndexUtils.getIndexTypeName(indexType)) : null;
        for (String normalizedAttributeName : normalizedAttributeNames) {
            newConfig.addAttribute(normalizedAttributeName);
            if (nameBuilder == null) continue;
            nameBuilder.append("_").append(normalizedAttributeName);
        }
        if (nameBuilder != null) {
            indexName = nameBuilder.toString();
        }
        newConfig.setName(indexName);
        newConfig.setBTreeIndexConfig(new BTreeIndexConfig(btreeIndexConfig));
        return newConfig;
    }

    public static void validateAttribute(IndexConfig config, String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Attribute name cannot be null: " + config);
        }
        String attributeName0 = attributeName.trim();
        if (attributeName0.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty: " + config);
        }
        if (attributeName0.endsWith(".")) {
            throw new IllegalArgumentException("Attribute name cannot end with dot [config=" + config + ", attribute=" + attributeName + "]");
        }
    }

    public static void validateAttribute(String attributeName) {
        if (attributeName == null) {
            throw new NullPointerException("Attribute name cannot be null.");
        }
        String attributeName0 = attributeName.trim();
        if (attributeName0.isEmpty()) {
            throw new IllegalArgumentException("Attribute name cannot be empty.");
        }
        if (attributeName0.endsWith(".")) {
            throw new IllegalArgumentException("Attribute name cannot end with dot: " + attributeName);
        }
    }

    public static String canonicalizeAttribute(String attribute) {
        return THIS_PATTERN.matcher(attribute).replaceFirst("");
    }

    public static IndexConfig createIndexConfig(IndexType type, String ... attributes) {
        IndexConfig res = new IndexConfig();
        res.setType(type);
        Preconditions.checkNotNull(attributes, "Index attributes cannot be null.");
        for (String attribute : attributes) {
            res.addAttribute(attribute);
        }
        return res;
    }

    private static String getIndexTypeName(IndexType type) {
        switch (type) {
            case SORTED: {
                return "sorted";
            }
            case HASH: {
                return "hash";
            }
            case BITMAP: {
                return "bitmap";
            }
        }
        throw new IllegalArgumentException("Unsupported index type: " + type);
    }
}

