/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexUtils;
import java.io.IOException;
import java.util.Map;

@BinaryInterface
public abstract class AbstractPredicate<K, V>
implements Predicate<K, V>,
IdentifiedDataSerializable {
    String attributeName;

    protected AbstractPredicate() {
    }

    protected AbstractPredicate(String attributeName) {
        this.attributeName = IndexUtils.canonicalizeAttribute(attributeName);
    }

    @Override
    public boolean apply(Map.Entry<K, V> mapEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.attributeName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributeName = in.readString();
    }

    @Override
    public int getFactoryId() {
        return -20;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractPredicate)) {
            return false;
        }
        AbstractPredicate that = (AbstractPredicate)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return this.attributeName != null ? this.attributeName.equals(that.attributeName) : that.attributeName == null;
    }

    public boolean canEqual(Object other) {
        return other instanceof AbstractPredicate;
    }

    public int hashCode() {
        return this.attributeName != null ? this.attributeName.hashCode() : 0;
    }
}

