/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.predicates.AbstractIndexAwarePredicate;
import com.hazelcast.query.impl.predicates.VisitablePredicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;

@BinaryInterface
public class InPredicate
extends AbstractIndexAwarePredicate
implements VisitablePredicate {
    private static final long serialVersionUID = 1L;
    Comparable[] values;

    public InPredicate() {
    }

    public InPredicate(String attribute, Comparable ... values) {
        super(attribute);
        if (values == null) {
            throw new NullPointerException("Array can't be null");
        }
        this.values = values;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Comparable[] getValues() {
        return this.values;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.values.length);
        for (Comparable value : this.values) {
            out.writeObject(value);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        int len = in.readInt();
        this.values = new Comparable[len];
        for (int i = 0; i < len; ++i) {
            this.values[i] = (Comparable)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeName);
        sb.append(" IN (");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof InPredicate)) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof InPredicate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

