/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import java.io.IOException;
import java.util.Map;

@BinaryInterface
public class InstanceOfPredicate
implements Predicate,
IdentifiedDataSerializable {
    private static final long serialVersionUID = 1L;
    private Class<?> klass;

    public InstanceOfPredicate(Class<?> klass) {
        this.klass = klass;
    }

    public InstanceOfPredicate() {
    }

    public boolean apply(Map.Entry mapEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.klass.getName());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        String klassName = in.readString();
        try {
            this.klass = ClassLoaderUtil.loadClass(in.getClassLoader(), klassName);
        }
        catch (ClassNotFoundException e) {
            throw new HazelcastSerializationException("Failed to load class: " + this.klass, e);
        }
    }

    public String toString() {
        return " instanceOf (" + this.klass.getName() + ")";
    }

    @Override
    public int getFactoryId() {
        return -20;
    }

    @Override
    public int getClassId() {
        return 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceOfPredicate)) {
            return false;
        }
        InstanceOfPredicate that = (InstanceOfPredicate)o;
        return this.klass != null ? this.klass.equals(that.klass) : that.klass == null;
    }

    public int hashCode() {
        return this.klass != null ? this.klass.hashCode() : 0;
    }
}

