/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.AndPredicate;
import com.hazelcast.query.impl.predicates.CompoundPredicate;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import com.hazelcast.query.impl.predicates.NegatablePredicate;
import com.hazelcast.query.impl.predicates.NotPredicate;
import com.hazelcast.query.impl.predicates.VisitablePredicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

@BinaryInterface
public final class OrPredicate
implements IndexAwarePredicate,
VisitablePredicate,
NegatablePredicate,
IdentifiedDataSerializable,
CompoundPredicate {
    private static final long serialVersionUID = 1L;
    protected Predicate[] predicates;

    public OrPredicate() {
    }

    public OrPredicate(Predicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean apply(Map.Entry mapEntry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.predicates.length);
        for (Predicate predicate : this.predicates) {
            out.writeObject(predicate);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.predicates = new Predicate[size];
        for (int i = 0; i < size; ++i) {
            this.predicates[i] = (Predicate)in.readObject();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int size = this.predicates.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(this.predicates[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Predicate negate() {
        int size = this.predicates.length;
        Predicate[] inners = new Predicate[size];
        for (int i = 0; i < size; ++i) {
            Predicate negated;
            Predicate original = this.predicates[i];
            if (original instanceof NegatablePredicate) {
                NegatablePredicate predicate = (NegatablePredicate)((Object)original);
                negated = predicate.negate();
            } else {
                negated = new NotPredicate(original);
            }
            inners[i] = negated;
        }
        AndPredicate andPredicate = new AndPredicate(inners);
        return andPredicate;
    }

    @Override
    public int getFactoryId() {
        return -20;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public <K, V> Predicate<K, V>[] getPredicates() {
        return this.predicates;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public <K, V> void setPredicates(Predicate<K, V>[] predicates) {
        if (this.predicates != null) {
            throw new IllegalStateException("Cannot reset predicates in an OrPredicate after they have been already set.");
        }
        this.predicates = predicates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrPredicate)) {
            return false;
        }
        OrPredicate that = (OrPredicate)o;
        return Arrays.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }
}

