/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static boolean isNull(Comparable value) {
        return value == null || value == AbstractIndex.NULL;
    }

    public static PagingPredicateImpl unwrapPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicateImpl) {
            PagingPredicateImpl impl = (PagingPredicateImpl)predicate;
            return impl;
        }
        Predicate unwrappedPredicate = ((PartitionPredicate)predicate).getTarget();
        return (PagingPredicateImpl)unwrappedPredicate;
    }

    public static void checkDoesNotContainPagingPredicate(Predicate predicate, String methodName) throws IllegalArgumentException {
        if (PredicateUtils.containsPagingPredicate(predicate)) {
            throw new IllegalArgumentException("Paging predicate is not supported in " + methodName + " method");
        }
    }

    public static boolean containsPagingPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicateImpl) {
            return true;
        }
        if (!(predicate instanceof PartitionPredicate)) {
            return false;
        }
        PartitionPredicate partitionPredicate = (PartitionPredicate)predicate;
        return partitionPredicate.getTarget() instanceof PagingPredicateImpl;
    }
}

