/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import java.io.IOException;
import java.util.concurrent.Callable;

public abstract class AbstractTaskDecorator<V>
implements Runnable,
Callable<V>,
IdentifiedDataSerializable {
    protected Object delegate;

    AbstractTaskDecorator() {
    }

    AbstractTaskDecorator(Runnable runnable) {
        this.delegate = runnable;
    }

    AbstractTaskDecorator(Callable<V> callable) {
        this.delegate = callable;
    }

    @Override
    public void run() {
        ((Runnable)this.delegate).run();
    }

    @Override
    public V call() throws Exception {
        return ((Callable)this.delegate).call();
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.delegate = in.readObject();
    }

    public boolean isDecoratedWith(Class<?> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return true;
        }
        Object object = this.delegate;
        if (object instanceof AbstractTaskDecorator) {
            AbstractTaskDecorator decorator = (AbstractTaskDecorator)object;
            return decorator.isDecoratedWith(clazz);
        }
        return clazz.isAssignableFrom(this.delegate.getClass());
    }

    public <T> T undecorateTo(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        Object object = this.delegate;
        if (object instanceof AbstractTaskDecorator) {
            AbstractTaskDecorator decorator = (AbstractTaskDecorator)object;
            return decorator.undecorateTo(clazz);
        }
        if (clazz.isAssignableFrom(this.delegate.getClass())) {
            return (T)this.delegate;
        }
        return null;
    }
}

