/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import java.util.concurrent.TimeUnit;

public class ScheduledTaskStatisticsImpl
implements ScheduledTaskStatistics {
    private static final TimeUnit MEASUREMENT_UNIT = TimeUnit.NANOSECONDS;
    private long runs;
    private long lastRunDuration;
    private long lastIdleDuration;
    private long totalRunDuration;
    private long totalIdleDuration;

    public ScheduledTaskStatisticsImpl(long runs, long lastIdleTimeNanos, long totalRunTimeNanos, long totalIdleTimeNanos, long lastRunDuration) {
        this.runs = runs;
        this.lastIdleDuration = lastIdleTimeNanos;
        this.totalRunDuration = totalRunTimeNanos;
        this.totalIdleDuration = totalIdleTimeNanos;
        this.lastRunDuration = lastRunDuration;
    }

    @Override
    public long getTotalRuns() {
        return this.runs;
    }

    @Override
    public long getLastRunDuration(TimeUnit unit) {
        return unit.convert(this.lastRunDuration, MEASUREMENT_UNIT);
    }

    @Override
    public long getLastIdleTime(TimeUnit unit) {
        return unit.convert(this.lastIdleDuration, MEASUREMENT_UNIT);
    }

    @Override
    public long getTotalIdleTime(TimeUnit unit) {
        return unit.convert(this.totalIdleDuration, MEASUREMENT_UNIT);
    }

    @Override
    public long getTotalRunTime(TimeUnit unit) {
        return unit.convert(this.totalRunDuration, MEASUREMENT_UNIT);
    }

    public String toString() {
        return "ScheduledTaskStatisticsImpl{runs=" + this.runs + ", lastIdleDuration=" + this.lastIdleDuration + ", totalRunDuration=" + this.totalRunDuration + ", totalIdleDuration=" + this.totalIdleDuration + ", lastRunDuration=" + this.lastRunDuration + "}";
    }
}

