/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.serialization.impl.Versioned;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class TaskDefinition<V>
implements Versioned {
    private Type type;
    private String name;
    private Callable<V> command;
    private long initialDelay;
    private long period;
    private TimeUnit unit;
    private boolean autoDisposable;

    public TaskDefinition(Type type, String name, Callable<V> command, long delay, TimeUnit unit, boolean autoDisposable) {
        this.type = type;
        this.name = name;
        this.command = command;
        this.initialDelay = delay;
        this.unit = unit;
        this.autoDisposable = autoDisposable;
    }

    public TaskDefinition(Type type, String name, Callable<V> command, long initialDelay, long period, TimeUnit unit, boolean autoDisposable) {
        this.type = type;
        this.name = name;
        this.command = command;
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.autoDisposable = autoDisposable;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Callable<V> getCommand() {
        return this.command;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isAutoDisposable() {
        return this.autoDisposable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.initialDelay == that.initialDelay && this.period == that.period && this.type == that.type && this.name.equals(that.name) && this.unit == that.unit && this.autoDisposable == that.autoDisposable;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.type, this.name, this.initialDelay, this.period, this.unit, this.autoDisposable});
    }

    public String toString() {
        return "TaskDefinition{type=" + this.type + ", name='" + this.name + "', command=" + this.command + ", initialDelay=" + this.initialDelay + ", period=" + this.period + ", unit=" + this.unit + ", autoDisposable=" + this.autoDisposable + "}";
    }

    public static enum Type {
        SINGLE_RUN(0),
        AT_FIXED_RATE(1);

        private final byte id;

        private Type(int status) {
            this.id = (byte)status;
        }

        public byte getId() {
            return this.id;
        }
    }
}

