/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.RealmConfigCallback;
import com.hazelcast.security.impl.LoginConfigurationDelegate;
import java.io.File;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class SecurityUtil {
    private static final String TEMP_LOGIN_CONTEXT_NAME = "realmConfigLogin";
    private static final String FQCN_KRB5LOGINMODULE_SUN = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String FQCN_KRB5LOGINMODULE_IBM = "com.ibm.security.auth.module.Krb5LoginModule";
    private static final ILogger LOGGER = Logger.getLogger(SecurityUtil.class);
    private static final ThreadLocal<Boolean> SECURE_CALL = new ThreadLocal();

    private SecurityUtil() {
    }

    public static Subject getRunAsSubject(CallbackHandler callbackHandler, String securityRealm) {
        if (securityRealm == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("No RunAs Subject created for callbackHandler=" + callbackHandler + ", realm is not provided");
            }
            return null;
        }
        RealmConfigCallback cb = new RealmConfigCallback(securityRealm);
        try {
            callbackHandler.handle(new Callback[]{cb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            LOGGER.info("Unable to retrieve the RealmConfig", e);
            return null;
        }
        return SecurityUtil.getRunAsSubject(callbackHandler, cb.getRealmConfig());
    }

    public static Subject getRunAsSubject(CallbackHandler callbackHandler, RealmConfig realmConfig) {
        if (realmConfig == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("The realmConfig is not provided.");
            }
            return null;
        }
        LoginConfigurationDelegate loginConfiguration = new LoginConfigurationDelegate(realmConfig.asLoginModuleConfigs());
        try {
            LoginContext lc = new LoginContext(TEMP_LOGIN_CONTEXT_NAME, new Subject(), callbackHandler, loginConfiguration);
            lc.login();
            return lc.getSubject();
        }
        catch (LoginException e) {
            LOGGER.info("Authentication failed.", e);
            return null;
        }
    }

    public static RealmConfig createKerberosJaasRealmConfig(String principal, String keytabPath, boolean isInitiator) {
        LoginModuleConfig krb5LoginModuleConfig;
        if (keytabPath == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("The keytab path is not provided.");
            }
            return null;
        }
        if (SecurityUtil.hasLoginModuleClass(FQCN_KRB5LOGINMODULE_SUN)) {
            krb5LoginModuleConfig = new LoginModuleConfig(FQCN_KRB5LOGINMODULE_SUN, LoginModuleConfig.LoginModuleUsage.REQUIRED).setOrClear("keyTab", keytabPath).setProperty("doNotPrompt", "true").setProperty("useKeyTab", "true").setProperty("storeKey", "true").setProperty("isInitiator", Boolean.toString(isInitiator));
        } else if (SecurityUtil.hasLoginModuleClass(FQCN_KRB5LOGINMODULE_IBM)) {
            krb5LoginModuleConfig = new LoginModuleConfig(FQCN_KRB5LOGINMODULE_IBM, LoginModuleConfig.LoginModuleUsage.REQUIRED).setProperty("useKeytab", new File(keytabPath).toURI().toString()).setProperty("credsType", isInitiator ? "both" : "acceptor");
        } else {
            throw new UnsupportedOperationException("No supported Krb5LoginModule was found in the current Java runtime. The JAAS security realm configurations can't be created automatically. You have to explicitly configure the realms.");
        }
        krb5LoginModuleConfig.setOrClear("principal", principal).setProperty("refreshKrb5Config", "true");
        RealmConfig kerberosRealmConfig = new RealmConfig().setJaasAuthenticationConfig(new JaasAuthenticationConfig().addLoginModuleConfig(krb5LoginModuleConfig));
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("A helper security realm for Kerberos keytab-based authentication was generated: " + kerberosRealmConfig);
        }
        return kerberosRealmConfig;
    }

    private static boolean hasLoginModuleClass(String fcqn) {
        try {
            Class.forName(fcqn);
            return true;
        }
        catch (Throwable t) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Login module class not found: " + fcqn, t);
            }
            return false;
        }
    }
}

