/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.SimpleTokenCredentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.impl.UnmodifiableLazyList;

public final class SpiDataSerializerHook
implements DataSerializerHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.spi", -1);
    public static final int UNMODIFIABLE_LAZY_LIST = 18;
    public static final int DISTRIBUTED_OBJECT_NS = 20;
    public static final int USERNAME_PWD_CRED = 23;
    public static final int SIMPLE_TOKEN_CRED = 24;
    private static final DataSerializableFactory FACTORY = SpiDataSerializerHook.createFactoryInternal();

    @Override
    public DataSerializableFactory createFactory() {
        return FACTORY;
    }

    private static DataSerializableFactory createFactoryInternal() {
        return new DataSerializableFactory(){

            @Override
            public IdentifiedDataSerializable create(int typeId) {
                return switch (typeId) {
                    case 18 -> new UnmodifiableLazyList();
                    case 23 -> new UsernamePasswordCredentials();
                    case 20 -> new DistributedObjectNamespace();
                    case 24 -> new SimpleTokenCredentials();
                    default -> null;
                };
            }
        };
    }

    @Override
    public int getFactoryId() {
        return F_ID;
    }
}

