/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.properties;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class ClusterProperty {
    public static final HazelcastProperty SOCKET_CLIENT_BUFFER_DIRECT = new HazelcastProperty("hazelcast.socket.client.buffer.direct", false);
    public static final HazelcastProperty IO_THREAD_COUNT = new HazelcastProperty("hazelcast.io.thread.count", new Function<HazelcastProperties, Integer>(){

        @Override
        public Integer apply(HazelcastProperties properties) {
            return this.getWhenNoSSLDetected();
        }

        private int getWhenNoSSLDetected() {
            return RuntimeAvailableProcessors.get() >= 20 ? 4 : 3;
        }
    });
    public static final HazelcastProperty CLIENT_PROTOCOL_UNVERIFIED_MESSAGE_BYTES = new HazelcastProperty("hazelcast.client.protocol.max.message.bytes", 4096);
    public static final HazelcastProperty PARTITION_COUNT = new HazelcastProperty("hazelcast.partition.count", 271);
    public static final HazelcastProperty DISCOVERY_SPI_ENABLED = new HazelcastProperty("hazelcast.discovery.enabled", false);
    public static final HazelcastProperty PARTITIONING_STRATEGY_CLASS = new HazelcastProperty("hazelcast.partitioning.strategy.class", "");
    public static final HazelcastProperty QUERY_RESULT_SIZE_LIMIT = new HazelcastProperty("hazelcast.query.result.size.limit", -1);
    public static final HazelcastProperty OPERATION_BACKUP_TIMEOUT_MILLIS = new HazelcastProperty("hazelcast.operation.backup.timeout.millis", 5000, TimeUnit.MILLISECONDS);
    public static final HazelcastProperty BACKPRESSURE_ENABLED = new HazelcastProperty("hazelcast.backpressure.enabled", false);
    public static final HazelcastProperty PARTITION_OPERATION_THREAD_COUNT = new HazelcastProperty("hazelcast.operation.thread.count", properties -> Math.max(2, RuntimeAvailableProcessors.get()));
    public static final HazelcastProperty GENERIC_OPERATION_THREAD_COUNT = new HazelcastProperty("hazelcast.operation.generic.thread.count", o -> {
        int processors = RuntimeAvailableProcessors.get();
        return Math.max(2, processors / 2);
    });
    public static final HazelcastProperty EVENT_THREAD_COUNT = new HazelcastProperty("hazelcast.event.thread.count", 5);
    public static final HazelcastProperty LOGGING_TYPE = new HazelcastProperty("hazelcast.logging.type", "jdk");
    public static final HazelcastProperty LOGGING_ENABLE_DETAILS = new HazelcastProperty("hazelcast.logging.details.enabled", true);
    public static final HazelcastProperty LOGGING_SHUTDOWN = new HazelcastProperty("hazelcast.logging.shutdown", false);
    public static final HazelcastProperty SERIALIZATION_VERSION = new HazelcastProperty("hazelcast.serialization.version", BuildInfoProvider.getBuildInfo().getSerializationVersion());

    private ClusterProperty() {
    }
}

