/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum RestEndpointGroup {
    CLUSTER_READ(0, true),
    CLUSTER_WRITE(1, false),
    HEALTH_CHECK(2, true),
    PERSISTENCE(3, false),
    HOT_RESTART(3, false),
    WAN(4, false),
    DATA(5, false),
    CP(6, false);

    private static final Map<Integer, RestEndpointGroup> CODE_TO_ENDPOINT_GROUPS_MAP;
    private final boolean enabledByDefault;
    private final int code;

    private RestEndpointGroup(int code, boolean enabledByDefault) {
        this.code = code;
        this.enabledByDefault = enabledByDefault;
    }

    public static Collection<RestEndpointGroup> getAllEndpointGroups() {
        return CODE_TO_ENDPOINT_GROUPS_MAP.values();
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public int getCode() {
        return this.code;
    }

    public static RestEndpointGroup getRestEndpointGroup(int code) {
        return CODE_TO_ENDPOINT_GROUPS_MAP.get(code);
    }

    static {
        CODE_TO_ENDPOINT_GROUPS_MAP = new HashMap<Integer, RestEndpointGroup>();
        for (RestEndpointGroup group : RestEndpointGroup.values()) {
            if (group == HOT_RESTART) continue;
            CODE_TO_ENDPOINT_GROUPS_MAP.put(group.getCode(), group);
        }
    }
}

