/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.impl.compact.CompactInternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactStreamSerializer;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.compact.CompactReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultCompactReader
extends CompactInternalGenericRecord
implements CompactReader {
    public DefaultCompactReader(CompactStreamSerializer serializer, BufferObjectDataInput in, Schema schema, @Nullable Class associatedClass, boolean schemaIncludedInBinary) {
        super(serializer, in, schema, associatedClass, schemaIncludedInBinary);
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName) {
        return this.getBoolean(fieldName);
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName, boolean defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.BOOLEAN) ? this.getBoolean(fieldName) : defaultValue;
    }

    @Override
    public byte readInt8(@Nonnull String fieldName) {
        return this.getInt8(fieldName);
    }

    @Override
    public byte readInt8(@Nonnull String fieldName, byte defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.INT8) ? this.getInt8(fieldName) : defaultValue;
    }

    @Override
    public short readInt16(@Nonnull String fieldName) {
        return this.getInt16(fieldName);
    }

    @Override
    public short readInt16(@Nonnull String fieldName, short defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.INT16) ? this.readInt16(fieldName) : defaultValue;
    }

    @Override
    public int readInt32(@Nonnull String fieldName) {
        return this.getInt32(fieldName);
    }

    @Override
    public int readInt32(@Nonnull String fieldName, int defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.INT32) ? this.getInt32(fieldName) : defaultValue;
    }

    @Override
    public long readInt64(@Nonnull String fieldName) {
        return this.getInt64(fieldName);
    }

    @Override
    public long readInt64(@Nonnull String fieldName, long defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.INT64) ? this.getInt64(fieldName) : defaultValue;
    }

    @Override
    public float readFloat32(@Nonnull String fieldName) {
        return this.getFloat32(fieldName);
    }

    @Override
    public float readFloat32(@Nonnull String fieldName, float defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.FLOAT32) ? this.getFloat32(fieldName) : defaultValue;
    }

    @Override
    public double readFloat64(@Nonnull String fieldName) {
        return this.getFloat64(fieldName);
    }

    @Override
    public double readFloat64(@Nonnull String fieldName, double defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.FLOAT64) ? this.getFloat64(fieldName) : defaultValue;
    }

    @Override
    public String readString(@Nonnull String fieldName) {
        return this.getString(fieldName);
    }

    @Override
    @Nullable
    public String readString(@Nonnull String fieldName, @Nullable String defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.STRING) ? this.getString(fieldName) : defaultValue;
    }

    @Override
    public BigDecimal readDecimal(@Nonnull String fieldName) {
        return this.getDecimal(fieldName);
    }

    @Override
    @Nullable
    public BigDecimal readDecimal(@Nonnull String fieldName, @Nullable BigDecimal defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.DECIMAL) ? this.getDecimal(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public LocalTime readTime(@Nonnull String fieldName) {
        return this.getTime(fieldName);
    }

    @Override
    @Nullable
    public LocalTime readTime(@Nonnull String fieldName, @Nullable LocalTime defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.TIME) ? this.getTime(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public LocalDate readDate(@Nonnull String fieldName) {
        return this.getDate(fieldName);
    }

    @Override
    @Nullable
    public LocalDate readDate(@Nonnull String fieldName, @Nullable LocalDate defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.DATE) ? this.getDate(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public LocalDateTime readTimestamp(@Nonnull String fieldName) {
        return this.getTimestamp(fieldName);
    }

    @Override
    @Nullable
    public LocalDateTime readTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.TIMESTAMP) ? this.getTimestamp(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public OffsetDateTime readTimestampWithTimezone(@Nonnull String fieldName) {
        return this.getTimestampWithTimezone(fieldName);
    }

    @Override
    @Nullable
    public OffsetDateTime readTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.TIMESTAMP_WITH_TIMEZONE) ? this.getTimestampWithTimezone(fieldName) : defaultValue;
    }

    @Override
    public <T> T readCompact(@Nonnull String fieldName) {
        return this.getObject(fieldName);
    }

    @Override
    @Nullable
    public <T> T readCompact(@Nonnull String fieldName, @Nullable T defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.COMPACT) ? this.getObject(fieldName) : defaultValue;
    }

    @Override
    public byte[] readArrayOfInt8(@Nonnull String fieldName) {
        return this.getArrayOfInt8(fieldName);
    }

    @Override
    @Nullable
    public byte[] readArrayOfInt8(@Nonnull String fieldName, @Nullable byte[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_INT8) ? this.getArrayOfInt8(fieldName) : defaultValue;
    }

    @Override
    public boolean[] readArrayOfBoolean(@Nonnull String fieldName) {
        return this.getArrayOfBoolean(fieldName);
    }

    @Override
    @Nullable
    public boolean[] readArrayOfBoolean(@Nonnull String fieldName, @Nullable boolean[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_BOOLEAN) ? this.getArrayOfBoolean(fieldName) : defaultValue;
    }

    @Override
    public int[] readArrayOfInt32(@Nonnull String fieldName) {
        return this.getArrayOfInt32(fieldName);
    }

    @Override
    @Nullable
    public int[] readArrayOfInt32(@Nonnull String fieldName, @Nullable int[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_INT32) ? this.getArrayOfInt32(fieldName) : defaultValue;
    }

    @Override
    public long[] readArrayOfInt64(@Nonnull String fieldName) {
        return this.getArrayOfInt64(fieldName);
    }

    @Override
    @Nullable
    public long[] readArrayOfInt64(@Nonnull String fieldName, @Nullable long[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_INT64) ? this.getArrayOfInt64(fieldName) : defaultValue;
    }

    @Override
    public double[] readArrayOfFloat64(@Nonnull String fieldName) {
        return this.getArrayOfFloat64(fieldName);
    }

    @Override
    @Nullable
    public double[] readArrayOfFloat64(@Nonnull String fieldName, @Nullable double[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_FLOAT64) ? this.getArrayOfFloat64(fieldName) : defaultValue;
    }

    @Override
    public float[] readArrayOfFloat32(@Nonnull String fieldName) {
        return this.getArrayOfFloat32(fieldName);
    }

    @Override
    @Nullable
    public float[] readArrayOfFloat32(@Nonnull String fieldName, @Nullable float[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_FLOAT32) ? this.getArrayOfFloat32(fieldName) : defaultValue;
    }

    @Override
    public short[] readArrayOfInt16(@Nonnull String fieldName) {
        return this.getArrayOfInt16(fieldName);
    }

    @Override
    @Nullable
    public short[] readArrayOfInt16(@Nonnull String fieldName, @Nullable short[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_INT16) ? this.getArrayOfInt16(fieldName) : defaultValue;
    }

    @Override
    public String[] readArrayOfString(@Nonnull String fieldName) {
        return this.getArrayOfString(fieldName);
    }

    @Override
    @Nullable
    public String[] readArrayOfString(@Nonnull String fieldName, @Nullable String[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_STRING) ? this.getArrayOfString(fieldName) : defaultValue;
    }

    @Override
    public BigDecimal[] readArrayOfDecimal(@Nonnull String fieldName) {
        return this.getArrayOfDecimal(fieldName);
    }

    @Override
    @Nullable
    public BigDecimal[] readArrayOfDecimal(@Nonnull String fieldName, @Nullable BigDecimal[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_DECIMAL) ? this.getArrayOfDecimal(fieldName) : defaultValue;
    }

    @Override
    public LocalTime[] readArrayOfTime(@Nonnull String fieldName) {
        return this.getArrayOfTime(fieldName);
    }

    @Override
    @Nullable
    public LocalTime[] readArrayOfTime(@Nonnull String fieldName, @Nullable LocalTime[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_TIME) ? this.getArrayOfTime(fieldName) : defaultValue;
    }

    @Override
    public LocalDate[] readArrayOfDate(@Nonnull String fieldName) {
        return this.getArrayOfDate(fieldName);
    }

    @Override
    @Nullable
    public LocalDate[] readArrayOfDate(@Nonnull String fieldName, @Nullable LocalDate[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_DATE) ? this.getArrayOfDate(fieldName) : defaultValue;
    }

    @Override
    public LocalDateTime[] readArrayOfTimestamp(@Nonnull String fieldName) {
        return this.getArrayOfTimestamp(fieldName);
    }

    @Override
    @Nullable
    public LocalDateTime[] readArrayOfTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_TIMESTAMP) ? this.getArrayOfTimestamp(fieldName) : defaultValue;
    }

    @Override
    public OffsetDateTime[] readArrayOfTimestampWithTimezone(@Nonnull String fieldName) {
        return this.getArrayOfTimestampWithTimezone(fieldName);
    }

    @Override
    @Nullable
    public OffsetDateTime[] readArrayOfTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_TIMESTAMP_WITH_TIMEZONE) ? this.getArrayOfTimestampWithTimezone(fieldName) : defaultValue;
    }

    @Override
    public <T> T[] readArrayOfCompact(@Nonnull String fieldName, Class<T> componentType) {
        return this.getArrayOfObject(fieldName, componentType);
    }

    @Override
    @Nullable
    public <T> T[] readArrayOfCompact(@Nonnull String fieldName, @Nullable Class<T> componentType, @Nullable T[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_COMPACT) ? this.getArrayOfObject(fieldName, componentType) : defaultValue;
    }

    @Override
    @Nullable
    public Boolean readNullableBoolean(@Nonnull String fieldName) {
        return this.getNullableBoolean(fieldName);
    }

    @Override
    @Nullable
    public Boolean readNullableBoolean(@Nonnull String fieldName, @Nullable Boolean defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_BOOLEAN) ? this.getNullableBoolean(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Byte readNullableInt8(@Nonnull String fieldName) {
        return this.getNullableInt8(fieldName);
    }

    @Override
    @Nullable
    public Byte readNullableInt8(@Nonnull String fieldName, @Nullable Byte defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_INT8) ? this.getNullableInt8(fieldName) : defaultValue;
    }

    @Override
    public Short readNullableInt16(@Nonnull String fieldName) {
        return this.getNullableInt16(fieldName);
    }

    @Override
    public Short readNullableInt16(@Nonnull String fieldName, @Nullable Short defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_INT16) ? this.getNullableInt16(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Integer readNullableInt32(@Nonnull String fieldName) {
        return this.getNullableInt32(fieldName);
    }

    @Override
    @Nullable
    public Integer readNullableInt32(@Nonnull String fieldName, @Nullable Integer defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_INT32) ? this.getNullableInt32(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Long readNullableInt64(@Nonnull String fieldName) {
        return this.getNullableInt64(fieldName);
    }

    @Override
    @Nullable
    public Long readNullableInt64(@Nonnull String fieldName, @Nullable Long defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_INT64) ? this.getNullableInt64(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Float readNullableFloat32(@Nonnull String fieldName) {
        return this.getNullableFloat32(fieldName);
    }

    @Override
    @Nullable
    public Float readNullableFloat32(@Nonnull String fieldName, @Nullable Float defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_FLOAT32) ? this.getNullableFloat32(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Double readNullableFloat64(@Nonnull String fieldName) {
        return this.getNullableFloat64(fieldName);
    }

    @Override
    @Nullable
    public Double readNullableFloat64(@Nonnull String fieldName, @Nullable Double defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.NULLABLE_FLOAT64) ? this.getNullableFloat64(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Boolean[] readArrayOfNullableBoolean(@Nonnull String fieldName) {
        return this.getArrayOfNullableBoolean(fieldName);
    }

    @Override
    @Nullable
    public Boolean[] readArrayOfNullableBoolean(@Nonnull String fieldName, @Nullable Boolean[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_BOOLEAN) ? this.getArrayOfNullableBoolean(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Byte[] readArrayOfNullableInt8(@Nonnull String fieldName) {
        return this.getArrayOfNullableInt8(fieldName);
    }

    @Override
    @Nullable
    public Byte[] readArrayOfNullableInt8(@Nonnull String fieldName, @Nullable Byte[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT8) ? this.getArrayOfNullableInt8(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Short[] readArrayOfNullableInt16(@Nonnull String fieldName) {
        return this.getArrayOfNullableInt16(fieldName);
    }

    @Override
    @Nullable
    public Short[] readArrayOfNullableInt16(@Nonnull String fieldName, @Nullable Short[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT16) ? this.getArrayOfNullableInt16(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Integer[] readArrayOfNullableInt32(@Nonnull String fieldName) {
        return this.getArrayOfNullableInt32(fieldName);
    }

    @Override
    @Nullable
    public Integer[] readArrayOfNullableInt32(@Nonnull String fieldName, @Nullable Integer[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT32) ? this.getArrayOfNullableInt32(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Long[] readArrayOfNullableInt64(@Nonnull String fieldName) {
        return this.getArrayOfNullableInt64(fieldName);
    }

    @Override
    @Nullable
    public Long[] readArrayOfNullableInt64(@Nonnull String fieldName, @Nullable Long[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_INT64) ? this.getArrayOfNullableInt64(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Float[] readArrayOfNullableFloat32(@Nonnull String fieldName) {
        return this.getArrayOfNullableFloat32(fieldName);
    }

    @Override
    @Nullable
    public Float[] readArrayOfNullableFloat32(@Nonnull String fieldName, @Nullable Float[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT32) ? this.getArrayOfNullableFloat32(fieldName) : defaultValue;
    }

    @Override
    @Nullable
    public Double[] readArrayOfNullableFloat64(@Nonnull String fieldName) {
        return this.getArrayOfNullableFloat64(fieldName);
    }

    @Override
    @Nullable
    public Double[] readArrayOfNullableFloat64(@Nonnull String fieldName, @Nullable Double[] defaultValue) {
        return this.isFieldExists(fieldName, FieldKind.ARRAY_OF_NULLABLE_FLOAT64) ? this.getArrayOfNullableFloat64(fieldName) : defaultValue;
    }
}

