/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.jdbc.JdbcUrl;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class HazelcastConfigFactory {
    private static final Map<String, BiConsumer<ClientConfig, String>> CONFIGURATION_MAPPING;

    HazelcastConfigFactory() {
    }

    private static void azureConfigMapping(Map<String, BiConsumer<ClientConfig, String>> map) {
        map.put("azureInstanceMetadataAvailable", (c, p) -> HazelcastConfigFactory.azureConfig(c, "instance-metadata-available", p));
        map.put("azureClientId", (c, p) -> HazelcastConfigFactory.azureConfig(c, "client-id", p));
        map.put("azureClientSecret", (c, p) -> HazelcastConfigFactory.azureConfig(c, "client-secret", p));
        map.put("azureTenantId", (c, p) -> HazelcastConfigFactory.azureConfig(c, "tenant-id", p));
        map.put("azureSubscriptionId", (c, p) -> HazelcastConfigFactory.azureConfig(c, "subscription-id", p));
        map.put("azureResourceGroup", (c, p) -> HazelcastConfigFactory.azureConfig(c, "resource-group", p));
        map.put("azureScaleSet", (c, p) -> HazelcastConfigFactory.azureConfig(c, "scale-set", p));
        map.put("azureUsePublicIp", (c, p) -> {
            AzureConfig cfr_ignored_0 = (AzureConfig)((AzureConfig)c.getNetworkConfig().getAzureConfig().setEnabled(true)).setUsePublicIp(p.equalsIgnoreCase("true"));
        });
    }

    private static void k8sConfigMapping(Map<String, BiConsumer<ClientConfig, String>> map) {
        map.put("k8sServiceDns", (c, p) -> HazelcastConfigFactory.k8sConfig(c, "service-dns", p));
        map.put("k8sServiceDnsTimeout", (c, p) -> HazelcastConfigFactory.k8sConfig(c, "service-dns-timeout", p));
        map.put("k8sNamespace", (c, p) -> HazelcastConfigFactory.k8sConfig(c, "namespace", p));
        map.put("k8sServiceName", (c, p) -> HazelcastConfigFactory.k8sConfig(c, "service-name", p));
        map.put("k8sServicePort", (c, p) -> HazelcastConfigFactory.k8sConfig(c, "service-port", p));
    }

    private static void sslConfigMapping(Map<String, BiConsumer<ClientConfig, String>> map) {
        map.put("sslEnabled", (c, p) -> HazelcastConfigFactory.sslConfig(c, ssl -> {
            SSLConfig cfr_ignored_0 = (SSLConfig)ssl.setEnabled(p.equalsIgnoreCase("true"));
        }));
        map.put("trustStore", (c, p) -> HazelcastConfigFactory.sslConfig(c, "trustStore", p));
        map.put("trustStorePassword", (c, p) -> HazelcastConfigFactory.sslConfig(c, "trustStorePassword", p));
        map.put("protocol", (c, p) -> HazelcastConfigFactory.sslConfig(c, "protocol", p));
        map.put("trustCertCollectionFile", (c, p) -> HazelcastConfigFactory.sslConfig(c, "trustCertCollectionFile", p));
        map.put("keyFile", (c, p) -> HazelcastConfigFactory.sslConfig(c, "keyFile", p));
        map.put("keyCertChainFile", (c, p) -> HazelcastConfigFactory.sslConfig(c, "keyCertChainFile", p));
        map.put("factoryClassName", (c, p) -> HazelcastConfigFactory.sslConfig(c, ssl -> ssl.setFactoryClassName((String)p)));
    }

    private static void awsConfigMapping(Map<String, BiConsumer<ClientConfig, String>> map) {
        map.put("awsTagKey", (c, v) -> HazelcastConfigFactory.awsConfig(c, "tag-key", v));
        map.put("awsTagValue", (c, v) -> HazelcastConfigFactory.awsConfig(c, "tag-value", v));
        map.put("awsAccessKey", (c, v) -> HazelcastConfigFactory.awsConfig(c, "access-key", v));
        map.put("awsSecretKey", (c, v) -> HazelcastConfigFactory.awsConfig(c, "secret-key", v));
        map.put("awsIamRole", (c, v) -> HazelcastConfigFactory.awsConfig(c, "iam-role", v));
        map.put("awsRegion", (c, v) -> HazelcastConfigFactory.awsConfig(c, "region", v));
        map.put("awsHostHeader", (c, v) -> HazelcastConfigFactory.awsConfig(c, "host-header", v));
        map.put("awsSecurityGroupName", (c, v) -> HazelcastConfigFactory.awsConfig(c, "security-group-name", v));
        map.put("awsConnectionTimeoutSeconds", (c, v) -> HazelcastConfigFactory.awsConfig(c, "connection-timeout-seconds", v));
        map.put("awsReadTimeoutSeconds", (c, v) -> HazelcastConfigFactory.awsConfig(c, "read-timeout-seconds", v));
        map.put("awsConnectionRetries", (c, v) -> HazelcastConfigFactory.awsConfig(c, "connection-retries", v));
        map.put("awsHzPort", (c, v) -> HazelcastConfigFactory.awsConfig(c, "hz-port", v));
        map.put("awsUsePublicIp", (c, v) -> HazelcastConfigFactory.awsConfig(c, "use-public-ip", v));
    }

    private static void gcpConfigMapping(Map<String, BiConsumer<ClientConfig, String>> map) {
        map.put("gcpPrivateKeyPath", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "private-key-path", v));
        map.put("gcpHzPort", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "hz-port", v));
        map.put("gcpProjects", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "projects", v));
        map.put("gcpRegion", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "region", v));
        map.put("gcpLabel", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "label", v));
        map.put("gcpUsePublicIp", (c, v) -> HazelcastConfigFactory.gcpConfig(c, "use-public-ip", v));
    }

    ClientConfig clientConfig(JdbcUrl url) {
        ClientConfig clientConfig = this.securityConfig(url, ClientConfig.load());
        String discoveryToken = url.getProperty("discoveryToken");
        if (discoveryToken != null) {
            return this.cloudConfig(url, clientConfig, discoveryToken);
        }
        ClientNetworkConfig networkConfig = new ClientNetworkConfig().setAddresses(url.getAuthorities());
        clientConfig.setNetworkConfig(networkConfig);
        CONFIGURATION_MAPPING.forEach((k, v) -> {
            String property = url.getProperty((String)k);
            if (property != null) {
                v.accept(clientConfig, property);
            }
        });
        return clientConfig;
    }

    private ClientConfig securityConfig(JdbcUrl url, ClientConfig clientConfig) {
        String user = url.getProperty("user");
        String password = url.getProperty("password");
        if (user != null || password != null) {
            clientConfig.getSecurityConfig().setCredentials(new UsernamePasswordCredentials(user, password));
        }
        return clientConfig;
    }

    private ClientConfig cloudConfig(JdbcUrl url, ClientConfig clientConfig, String discoveryToken) {
        clientConfig.setProperty(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN.getName(), discoveryToken);
        clientConfig.setClusterName(url.getRawAuthority());
        return clientConfig;
    }

    private static void k8sConfig(ClientConfig clientConfig, String property, String value) {
        ((KubernetesConfig)clientConfig.getNetworkConfig().getKubernetesConfig().setEnabled(true)).setProperty(property, value);
    }

    private static void sslConfig(ClientConfig clientConfig, String property, String value) {
        SSLConfig sslConfig = clientConfig.getNetworkConfig().getSSLConfig();
        if (sslConfig == null) {
            sslConfig = new SSLConfig();
        }
        sslConfig.setProperty(property, value);
        clientConfig.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private static void sslConfig(ClientConfig clientConfig, Consumer<SSLConfig> sslConfigFunction) {
        SSLConfig sslConfig = clientConfig.getNetworkConfig().getSSLConfig();
        if (sslConfig == null) {
            sslConfig = new SSLConfig();
        }
        sslConfigFunction.accept(sslConfig);
        clientConfig.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private static void awsConfig(ClientConfig clientConfig, String property, String value) {
        ((AwsConfig)clientConfig.getNetworkConfig().getAwsConfig().setEnabled(true)).setProperty(property, value);
    }

    private static void azureConfig(ClientConfig clientConfig, String property, String value) {
        ((AzureConfig)clientConfig.getNetworkConfig().getAzureConfig().setEnabled(true)).setProperty(property, value);
    }

    private static void gcpConfig(ClientConfig clientConfig, String property, String value) {
        ((GcpConfig)clientConfig.getNetworkConfig().getGcpConfig().setEnabled(true)).setProperty(property, value);
    }

    static {
        HashMap<String, BiConsumer<ClientConfig, String>> map = new HashMap<String, BiConsumer<ClientConfig, String>>();
        map.put("clusterName", ClientConfig::setClusterName);
        HazelcastConfigFactory.gcpConfigMapping(map);
        HazelcastConfigFactory.awsConfigMapping(map);
        HazelcastConfigFactory.azureConfigMapping(map);
        HazelcastConfigFactory.sslConfigMapping(map);
        HazelcastConfigFactory.k8sConfigMapping(map);
        CONFIGURATION_MAPPING = Collections.unmodifiableMap(map);
    }
}

