/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jdbc;

import com.hazelcast.jdbc.JdbcUtils;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRowMetadata;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class JdbcResultSetMetaData
implements ResultSetMetaData {
    private static final String NOT_APPLICABLE = "";
    private static final Map<SqlColumnType, Integer> SQL_TYPES_MAPPING = new HashMap<SqlColumnType, Integer>();
    private static final Map<SqlColumnType, SqlTypeInfo> SQL_TYPES_INFO = new HashMap<SqlColumnType, SqlTypeInfo>();
    private final SqlRowMetadata sqlRowMetadata;

    JdbcResultSetMetaData(SqlRowMetadata sqlRowMetadata) {
        this.sqlRowMetadata = sqlRowMetadata;
    }

    private static void initSqlTypesMapping() {
        SQL_TYPES_MAPPING.put(SqlColumnType.VARCHAR, 12);
        SQL_TYPES_MAPPING.put(SqlColumnType.BOOLEAN, 16);
        SQL_TYPES_MAPPING.put(SqlColumnType.TINYINT, -6);
        SQL_TYPES_MAPPING.put(SqlColumnType.SMALLINT, 5);
        SQL_TYPES_MAPPING.put(SqlColumnType.INTEGER, 4);
        SQL_TYPES_MAPPING.put(SqlColumnType.BIGINT, -5);
        SQL_TYPES_MAPPING.put(SqlColumnType.DECIMAL, 3);
        SQL_TYPES_MAPPING.put(SqlColumnType.REAL, 7);
        SQL_TYPES_MAPPING.put(SqlColumnType.DOUBLE, 8);
        SQL_TYPES_MAPPING.put(SqlColumnType.DATE, 91);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIME, 92);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIMESTAMP, 93);
        SQL_TYPES_MAPPING.put(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, 2014);
        SQL_TYPES_MAPPING.put(SqlColumnType.OBJECT, 2000);
        SQL_TYPES_MAPPING.put(SqlColumnType.NULL, 0);
    }

    private static void initSqlTypesInfo() {
        SQL_TYPES_INFO.put(SqlColumnType.INTEGER, new SqlTypeInfo(11, 11, 0));
        SQL_TYPES_INFO.put(SqlColumnType.BIGINT, new SqlTypeInfo(20, 20, 0));
        SQL_TYPES_INFO.put(SqlColumnType.VARCHAR, new SqlTypeInfo(64, Integer.MAX_VALUE, 0));
        SQL_TYPES_INFO.put(SqlColumnType.BOOLEAN, new SqlTypeInfo(5, 1, 0));
        SQL_TYPES_INFO.put(SqlColumnType.TINYINT, new SqlTypeInfo(4, 8, 0));
        SQL_TYPES_INFO.put(SqlColumnType.SMALLINT, new SqlTypeInfo(6, 16, 0));
        SQL_TYPES_INFO.put(SqlColumnType.REAL, new SqlTypeInfo(15, 24, 24));
        SQL_TYPES_INFO.put(SqlColumnType.DOUBLE, new SqlTypeInfo(24, 53, 53));
        SQL_TYPES_INFO.put(SqlColumnType.DECIMAL, new SqlTypeInfo(100000, 38, 38));
        SQL_TYPES_INFO.put(SqlColumnType.NULL, new SqlTypeInfo(53, 1, 0));
        SQL_TYPES_INFO.put(SqlColumnType.OBJECT, new SqlTypeInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, 0));
        SQL_TYPES_INFO.put(SqlColumnType.DATE, new SqlTypeInfo(10, 10, 0));
        SQL_TYPES_INFO.put(SqlColumnType.TIME, new SqlTypeInfo(8, 8, 0));
        SQL_TYPES_INFO.put(SqlColumnType.TIMESTAMP, new SqlTypeInfo(25, 25, 0));
        SQL_TYPES_INFO.put(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, new SqlTypeInfo(25, 25, 0));
    }

    @Override
    public int getColumnCount() {
        return this.sqlRowMetadata.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        return 1;
    }

    @Override
    public boolean isSigned(int column) {
        SqlColumnType type = this.getColumn(column).getType();
        switch (type) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return SQL_TYPES_INFO.get((Object)this.getColumn(column).getType()).displaySize;
    }

    @Override
    public String getColumnLabel(int column) {
        return this.getColumn(column).getName();
    }

    @Override
    public String getColumnName(int column) {
        return this.getColumn(column).getName();
    }

    @Override
    public String getSchemaName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public int getPrecision(int column) {
        return SQL_TYPES_INFO.get((Object)this.getColumn(column).getType()).precision;
    }

    @Override
    public int getScale(int column) {
        return SQL_TYPES_INFO.get((Object)this.getColumn(column).getType()).scale;
    }

    @Override
    public String getTableName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public String getCatalogName(int column) {
        return NOT_APPLICABLE;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        SqlColumnType hzType = this.getColumn(column).getType();
        Integer jdbcType = SQL_TYPES_MAPPING.get((Object)hzType);
        if (jdbcType == null) {
            throw new SQLException("Type mapping not found for type: " + (Object)((Object)hzType));
        }
        return jdbcType;
    }

    @Override
    public String getColumnTypeName(int column) {
        return this.getColumn(column).getType().name();
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isWritable(int column) {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return this.getColumn(column).getType().getValueClass().getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return JdbcUtils.unwrap(this, iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return JdbcUtils.isWrapperFor(this, iface);
    }

    private SqlColumnMetadata getColumn(int column) {
        if (column <= 0 || column > this.getColumnCount()) {
            throw new IndexOutOfBoundsException("Column index is out of bounds: " + column);
        }
        return this.sqlRowMetadata.getColumn(column - 1);
    }

    static {
        JdbcResultSetMetaData.initSqlTypesMapping();
        JdbcResultSetMetaData.initSqlTypesInfo();
    }

    private static final class SqlTypeInfo {
        private final Integer displaySize;
        private final Integer precision;
        private final Integer scale;

        private SqlTypeInfo(Integer displaySize, Integer precision, Integer scale) {
            this.displaySize = displaySize;
            this.precision = precision;
            this.scale = scale;
        }
    }
}

