/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.TxnReservedCapacityCounter;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.tenantcontrol.TenantControl;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public abstract class MapOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
ServiceNamespaceAware {
    private static final boolean ASSERTION_ENABLED = MapOperation.class.desiredAssertionStatus();
    protected transient MapService mapService;
    protected transient RecordStore<Record> recordStore;
    protected transient MapContainer mapContainer;
    protected transient MapServiceContext mapServiceContext;
    protected transient MapEventPublisher mapEventPublisher;
    protected transient boolean createRecordStoreOnDemand = true;
    protected transient boolean disposeDeferredBlocks = true;
    private transient boolean canPublishWanEvent;

    public MapOperation() {
    }

    public MapOperation(String name) {
        this.name = name;
    }

    @Override
    public final void beforeRun() throws Exception {
        super.beforeRun();
        this.mapService = (MapService)this.getService();
        this.mapServiceContext = this.mapService.getMapServiceContext();
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        try {
            this.recordStore = this.getRecordStoreOrNull();
            this.mapContainer = this.recordStore == null ? this.mapServiceContext.getMapContainer(this.name) : this.recordStore.getMapContainer();
        }
        catch (Throwable t) {
            this.disposeDeferredBlocks();
            throw ExceptionUtil.rethrow(t, Exception.class);
        }
        this.canPublishWanEvent = this.canPublishWanEvent(this.mapContainer);
        this.assertNativeMapOnPartitionThread();
        this.innerBeforeRun();
    }

    protected void innerBeforeRun() throws Exception {
        if (this.recordStore != null) {
            this.recordStore.beforeOperation();
        }
    }

    @Override
    public final void run() {
        try {
            this.runInternal();
        }
        catch (NativeOutOfMemoryError e) {
            this.rerunWithForcedEviction();
        }
    }

    protected void runInternal() {
    }

    private void rerunWithForcedEviction() {
        try {
            ForcedEviction.runWithForcedEvictionStrategies(this);
        }
        catch (NativeOutOfMemoryError e) {
            this.disposeDeferredBlocks();
            throw e;
        }
    }

    @Override
    public final void afterRun() throws Exception {
        this.afterRunInternal();
        this.disposeDeferredBlocks();
        super.afterRun();
    }

    protected void afterRunInternal() {
    }

    @Override
    public void afterRunFinal() {
        if (this.recordStore != null) {
            this.recordStore.afterOperation();
        }
    }

    protected void assertNativeMapOnPartitionThread() {
        if (!ASSERTION_ENABLED) {
            return;
        }
        assert (this.mapContainer.getMapConfig().getInMemoryFormat() != InMemoryFormat.NATIVE || this.getPartitionId() != -1) : "Native memory backed map operations are not allowed to run on GENERIC_PARTITION_ID";
    }

    ILogger logger() {
        return this.getLogger();
    }

    protected final CallerProvenance getCallerProvenance() {
        return this.disableWanReplicationEvent() ? CallerProvenance.WAN : CallerProvenance.NOT_WAN;
    }

    private RecordStore getRecordStoreOrNull() {
        int partitionId = this.getPartitionId();
        if (partitionId == -1) {
            return null;
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        if (this.createRecordStoreOnDemand) {
            return partitionContainer.getRecordStore(this.name);
        }
        return partitionContainer.getExistingRecordStore(this.name);
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        this.disposeDeferredBlocks();
        super.onExecutionFailure(e);
    }

    @Override
    public void logError(Throwable e) {
        ILogger logger = this.getLogger();
        if (e instanceof NativeOutOfMemoryError) {
            Level level = this instanceof BackupOperation ? Level.FINEST : Level.WARNING;
            logger.log(level, "Cannot complete operation! -> " + e.getMessage());
        } else {
            this.disposeDeferredBlocks();
            super.logError(e);
        }
    }

    void disposeDeferredBlocks() {
        if (!this.disposeDeferredBlocks || this.recordStore == null || this.recordStore.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return;
        }
        this.recordStore.disposeDeferredBlocks();
    }

    private boolean canPublishWanEvent(MapContainer mapContainer) {
        boolean canPublishWanEvent;
        boolean bl = canPublishWanEvent = mapContainer.isWanReplicationEnabled() && !this.disableWanReplicationEvent();
        if (canPublishWanEvent) {
            mapContainer.getWanReplicationDelegate().doPrepublicationChecks();
        }
        return canPublishWanEvent;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    public boolean isPostProcessing(RecordStore recordStore) {
        MapDataStore<Data, Object> mapDataStore = recordStore.getMapDataStore();
        return mapDataStore.isPostProcessingMapStore() || !this.mapContainer.getInterceptorRegistry().getInterceptors().isEmpty();
    }

    public void setThreadId(long threadId) {
        throw new UnsupportedOperationException();
    }

    public long getThreadId() {
        throw new UnsupportedOperationException();
    }

    protected final void invalidateNearCache(List<Data> keys) {
        if (!this.mapContainer.hasInvalidationListener() || CollectionUtil.isEmpty(keys)) {
            return;
        }
        Invalidator invalidator = this.getNearCacheInvalidator();
        for (Data key : keys) {
            invalidator.invalidateKey(key, this.name, this.getCallerUuid());
        }
    }

    public final void invalidateNearCache(Data key) {
        if (!this.mapContainer.hasInvalidationListener() || key == null) {
            return;
        }
        Invalidator invalidator = this.getNearCacheInvalidator();
        invalidator.invalidateKey(key, this.name, this.getCallerUuid());
    }

    protected final void invalidateAllKeysInNearCaches() {
        if (this.mapContainer.hasInvalidationListener()) {
            int partitionId = this.getPartitionId();
            Invalidator invalidator = this.getNearCacheInvalidator();
            if (partitionId == this.getNodeEngine().getPartitionService().getPartitionId(this.name)) {
                invalidator.invalidateAllKeys(this.name, this.getCallerUuid());
            } else {
                invalidator.forceIncrementSequence(this.name, this.getPartitionId());
            }
        }
    }

    private Invalidator getNearCacheInvalidator() {
        MapNearCacheManager mapNearCacheManager = this.mapServiceContext.getMapNearCacheManager();
        return mapNearCacheManager.getInvalidator();
    }

    protected final void evict(Data justAddedKey) {
        if (this.mapContainer.getEvictor() == Evictor.NULL_EVICTOR) {
            return;
        }
        this.recordStore.evictEntries(justAddedKey);
        this.disposeDeferredBlocks();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public ObjectNamespace getServiceNamespace() {
        MapContainer container = this.mapContainer;
        if (container == null) {
            MapService service = (MapService)this.getService();
            container = service.getMapServiceContext().getMapContainer(this.name);
        }
        return container.getObjectNamespace();
    }

    public void setMapService(MapService mapService) {
        this.mapService = mapService;
    }

    public void setMapContainer(MapContainer mapContainer) {
        this.mapContainer = mapContainer;
    }

    protected final void publishWanUpdate(Data dataKey, Object value) {
        this.publishWanUpdateInternal(dataKey, value, false);
    }

    private void publishWanUpdateInternal(Data dataKey, Object value, boolean hasLoadProvenance) {
        if (!this.canPublishWanEvent) {
            return;
        }
        Record record = this.recordStore.getRecord(dataKey);
        if (record == null) {
            return;
        }
        Data dataValue = ToHeapDataConverter.toHeapData(this.mapServiceContext.toData(value));
        ExpiryMetadata expiryMetadata = this.recordStore.getExpirySystem().getExpiryMetadata(dataKey);
        WanMapEntryView<Object, Object> entryView = EntryViews.createWanEntryView(ToHeapDataConverter.toHeapData(dataKey), dataValue, record, expiryMetadata, this.getNodeEngine().getSerializationService());
        this.mapEventPublisher.publishWanUpdate(this.name, entryView, hasLoadProvenance);
    }

    protected final void publishLoadAsWanUpdate(Data dataKey, Object value) {
        this.publishWanUpdateInternal(dataKey, value, true);
    }

    protected final void publishWanRemove(@Nonnull Data dataKey) {
        if (!this.canPublishWanEvent) {
            return;
        }
        this.mapEventPublisher.publishWanRemove(this.name, ToHeapDataConverter.toHeapData(dataKey));
    }

    protected boolean disableWanReplicationEvent() {
        return false;
    }

    protected final TxnReservedCapacityCounter wbqCapacityCounter() {
        return this.recordStore.getMapDataStore().getTxnReservedCapacityCounter();
    }

    protected final Data getValueOrPostProcessedValue(Record record, Data dataValue) {
        if (!this.isPostProcessing(this.recordStore)) {
            return dataValue;
        }
        return this.mapServiceContext.toData(record.getValue());
    }

    @Override
    public TenantControl getTenantControl() {
        return this.getNodeEngine().getTenantControlService().getTenantControl("hz:impl:mapService", this.name);
    }

    @Override
    public boolean requiresTenantContext() {
        return true;
    }
}

