/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema.internal;

import com.hazelcast.org.everit.json.schema.FormatValidator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public class URIReferenceFormatValidator
implements FormatValidator {
    @Override
    public Optional<String> validate(String subject) {
        try {
            new URI(subject);
            return Optional.empty();
        }
        catch (URISyntaxException e) {
            return this.failure(subject);
        }
    }

    protected Optional<String> failure(String subject) {
        return Optional.of(String.format("[%s] is not a valid URI reference", subject));
    }

    @Override
    public String formatName() {
        return "uri-reference";
    }
}

