/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema.loader;

import com.hazelcast.org.everit.json.schema.ConditionalSchema;
import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.loader.AbstractSchemaExtractor;
import com.hazelcast.org.everit.json.schema.loader.SchemaLoader;
import com.hazelcast.org.everit.json.schema.loader.SpecificationVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class PropertySnifferSchemaExtractor
extends AbstractSchemaExtractor {
    static final List<String> CONDITIONAL_SCHEMA_KEYWORDS = Arrays.asList("if", "then", "else");

    PropertySnifferSchemaExtractor(SchemaLoader defaultLoader) {
        super(defaultLoader);
    }

    @Override
    List<Schema.Builder<?>> extract() {
        ArrayList builders = new ArrayList(1);
        if (this.schemaHasAnyOf(this.config().specVersion.arrayKeywords())) {
            builders.add(this.buildArraySchema().requiresArray(false));
        }
        if (this.schemaHasAnyOf(this.config().specVersion.objectKeywords())) {
            builders.add(this.buildObjectSchema().requiresObject(false));
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            builders.add(this.buildNumberSchema().requiresNumber(false));
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            builders.add(this.buildStringSchema().requiresString(false));
        }
        if (this.config().specVersion.isAtLeast(SpecificationVersion.DRAFT_7) && this.schemaHasAnyOf(CONDITIONAL_SCHEMA_KEYWORDS)) {
            builders.add(this.buildConditionalSchema());
        }
        return builders;
    }

    private ConditionalSchema.Builder buildConditionalSchema() {
        ConditionalSchema.Builder builder = ConditionalSchema.builder();
        this.maybe("if").map(this.defaultLoader::loadChild).map(Schema.Builder::build).ifPresent(builder::ifSchema);
        this.maybe("then").map(this.defaultLoader::loadChild).map(Schema.Builder::build).ifPresent(builder::thenSchema);
        this.maybe("else").map(this.defaultLoader::loadChild).map(Schema.Builder::build).ifPresent(builder::elseSchema);
        return builder;
    }
}

