/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.partition.Partition;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.version.MemberVersion;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class QueryUtils {
    public static final String CATALOG = "hazelcast";
    public static final String WORKER_TYPE_STATE_CHECKER = "query-state-checker";

    private QueryUtils() {
    }

    public static String workerName(String instanceName, String workerType) {
        return instanceName + "-" + workerType;
    }

    public static HazelcastSqlException toPublicException(Throwable e, @Nonnull UUID localMemberId) {
        if (e instanceof HazelcastSqlException) {
            return (HazelcastSqlException)e;
        }
        if (e instanceof QueryException) {
            QueryException e0 = (QueryException)e;
            UUID originatingMemberId = e0.getOriginatingMemberId();
            if (originatingMemberId == null) {
                originatingMemberId = localMemberId;
            }
            return new HazelcastSqlException(originatingMemberId, e0.getCode(), e0.getMessage(), e, e0.getSuggestion());
        }
        return new HazelcastSqlException(localMemberId, -1, e.getMessage(), e, null);
    }

    public static SqlColumnMetadata getColumnMetadata(String columnName, QueryDataType columnType, boolean columnIsNullable) {
        return new SqlColumnMetadata(columnName, columnType.getTypeFamily().getPublicType(), columnIsNullable);
    }

    public static Map<UUID, PartitionIdSet> createPartitionMap(NodeEngine nodeEngine, @Nullable MemberVersion localMemberVersion, boolean failOnUnassignedPartition) {
        Set<Partition> parts = nodeEngine.getHazelcastInstance().getPartitionService().getPartitions();
        int partCnt = parts.size();
        LinkedHashMap<UUID, PartitionIdSet> partMap = new LinkedHashMap<UUID, PartitionIdSet>();
        for (Partition part : parts) {
            Member owner = part.getOwner();
            if (owner == null) {
                if (!failOnUnassignedPartition) continue;
                throw QueryException.error(1005, "Partition is not assigned to any member: " + part.getPartitionId());
            }
            if (localMemberVersion != null && !localMemberVersion.equals(owner.getVersion())) {
                UUID localMemberId = nodeEngine.getLocalMember().getUuid();
                throw QueryException.error("Cannot execute SQL query when members have different versions (make sure that all members have the same version) {localMemberId=" + localMemberId + ", localMemberVersion=" + localMemberVersion + ", remoteMemberId=" + owner.getUuid() + ", remoteMemberVersion=" + owner.getVersion() + "}");
            }
            partMap.computeIfAbsent(owner.getUuid(), key -> new PartitionIdSet(partCnt)).add(part.getPartitionId());
        }
        return partMap;
    }

    public static List<List<String>> prepareSearchPaths(List<List<String>> currentSearchPaths, List<TableResolver> tableResolvers) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        if (currentSearchPaths != null) {
            res.addAll(currentSearchPaths);
        }
        if (tableResolvers != null) {
            for (TableResolver tableResolver : tableResolvers) {
                res.addAll(tableResolver.getDefaultSearchPaths());
            }
        }
        res.add(Collections.singletonList(CATALOG));
        res.add(Collections.emptyList());
        return res;
    }

    @Nullable
    public static Member memberOfLargerSameVersionGroup(@Nonnull Collection<Member> members, @Nullable Member localMember) {
        Version version;
        int count;
        Version version0 = null;
        Version version1 = null;
        int count0 = 0;
        int count1 = 0;
        int grossMajority = members.size() / 2;
        for (Member m : members) {
            int currentCount;
            if (m.isLiteMember()) continue;
            Version v = m.getVersion().asVersion();
            if (version0 == null || version0.equals(v)) {
                version0 = v;
                currentCount = ++count0;
            } else if (version1 == null || version1.equals(v)) {
                version1 = v;
                currentCount = ++count1;
            } else {
                throw new RuntimeException("More than 2 distinct member versions found: " + version0 + ", " + version1 + ", " + v);
            }
            if (currentCount <= grossMajority || localMember == null || !localMember.getVersion().asVersion().equals(v)) continue;
            return localMember;
        }
        assert (count1 == 0 || count0 > 0);
        if (count0 == 0) {
            return null;
        }
        if (count0 > count1 || count0 == count1 && version0.compareTo(version1) > 0) {
            count = count0;
            version = version0;
        } else {
            count = count1;
            version = version1;
        }
        if (localMember != null && !localMember.isLiteMember() && localMember.getVersion().asVersion().equals(version)) {
            return localMember;
        }
        int randomMemberIndex = ThreadLocalRandom.current().nextInt(count);
        for (Member m : members) {
            if (m.isLiteMember() || !m.getVersion().asVersion().equals(version) || --randomMemberIndex >= 0) continue;
            return m;
        }
        throw new RuntimeException("should never get here");
    }
}

