/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.AbstractGenericExtractor;
import com.hazelcast.sql.impl.extract.GenericTargetAccessor;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeMismatchException;

public class GenericTargetExtractor
extends AbstractGenericExtractor {
    public GenericTargetExtractor(boolean key, GenericTargetAccessor targetAccessor, QueryDataType type) {
        super(key, targetAccessor, type);
    }

    @Override
    public Object get() {
        try {
            return this.targetAccessor.getTargetForDirectAccess(this.type);
        }
        catch (QueryDataTypeMismatchException e) {
            throw QueryException.dataException("Failed to extract map entry " + (this.key ? "key" : "value") + " because of type mismatch [expectedClass=" + e.getExpectedClass().getName() + ", actualClass=" + e.getActualClass().getName() + ']');
        }
        catch (Exception e) {
            throw QueryException.dataException("Failed to extract map entry " + (this.key ? "key" : "value") + ": " + e.getMessage(), e);
        }
    }
}

