/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.core.IMap;
import com.hazelcast.session.HazelcastSessionData;
import com.hazelcast.session.HazelcastSessionIdManager;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HazelcastSessionManager
extends NoSqlSessionManager {
    private static final Logger LOG = Log.getLogger(HazelcastSessionManager.class);
    private String contextId;
    private IMap<String, HazelcastSessionData> sessions;

    public void doStart() throws Exception {
        String contextPath;
        LOG.info("HazelcastSessionManager.doStart()", new Object[0]);
        super.doStart();
        String[] hosts = this.getContextHandler().getVirtualHosts();
        if (hosts == null || hosts.length == 0) {
            hosts = this.getContextHandler().getConnectorNames();
        }
        if (hosts == null || hosts.length == 0) {
            hosts = new String[]{"::"};
        }
        if ((contextPath = this.getContext().getContextPath()) == null || "".equals(contextPath)) {
            contextPath = "*";
        }
        LOG.debug("HazelcastSessionManager:doStart():contextpath: " + contextPath, new Object[0]);
        this.contextId = this.createContextId(hosts, contextPath);
        LOG.debug("HazelcastSessionManager:doStart():contextId: " + this.contextId, new Object[0]);
        this.sessions = ((HazelcastSessionIdManager)this.getSessionIdManager()).getSessions();
    }

    protected Object save(NoSqlSession session, Object version, boolean activateAfterSave) {
        LOG.info("HazelcastSessionManager:save: " + session, new Object[0]);
        session.willPassivate();
        HazelcastSessionData sessionData = (HazelcastSessionData)this.sessions.get((Object)session.getClusterId());
        if (sessionData == null) {
            sessionData = new HazelcastSessionData();
        }
        if (session.isValid()) {
            version = this.handleSessionAddition(session, version, sessionData);
        } else {
            sessionData.setValid(false);
        }
        this.sessions.set((Object)session.getClusterId(), (Object)sessionData);
        if (activateAfterSave) {
            session.didActivate();
        }
        return version;
    }

    private Object handleSessionAddition(NoSqlSession session, Object version, HazelcastSessionData sessionData) {
        if (version == null) {
            version = new Long(1L);
            sessionData.setCreationTime(session.getCreationTime());
            sessionData.setValid(true);
        } else {
            version = new Long(((Number)version).longValue() + 1L);
        }
        sessionData.setVersion(version);
        sessionData.setAccessed(session.getAccessed());
        Set names = session.takeDirty();
        if (this.isSaveAllAttributes()) {
            names.addAll(session.getNames());
        }
        for (String name : names) {
            Object value = session.getAttribute(name);
            if (value == null) {
                sessionData.getAttributeMap().remove(name);
                continue;
            }
            if (value instanceof Serializable) {
                sessionData.getAttributeMap().put(name, value);
                continue;
            }
            LOG.warn("Session attribute [" + name + "] not saved since it's not Serializable", new Object[0]);
        }
        return version;
    }

    protected Object refresh(NoSqlSession session, Object version) {
        HazelcastSessionData o;
        LOG.info("HazelcastSessionManager:refresh: " + session, new Object[0]);
        if (version != null && (o = (HazelcastSessionData)this.sessions.get((Object)session.getClusterId())) != null) {
            Object saved = o.getVersion();
            if (saved != null && saved.equals(version)) {
                return version;
            }
            version = saved;
        }
        if ((o = (HazelcastSessionData)this.sessions.get((Object)session.getClusterId())) == null) {
            session.invalidate();
            return null;
        }
        Boolean valid = o.isValid();
        if (valid == null || !valid.booleanValue()) {
            session.invalidate();
            return null;
        }
        session.willPassivate();
        session.clearAttributes();
        this.handleSessionBindings(session, o);
        o.setAccessed(System.currentTimeMillis());
        this.sessions.set((Object)session.getClusterId(), (Object)o);
        session.didActivate();
        return version;
    }

    private void handleSessionBindings(NoSqlSession session, HazelcastSessionData o) {
        Map<String, Object> attrs = o.getAttributeMap();
        if (attrs != null) {
            Iterator<String> i$ = attrs.keySet().iterator();
            while (i$.hasNext()) {
                String name;
                String attr = name = i$.next();
                Object value = attrs.get(name);
                if (attrs.keySet().contains(name)) {
                    session.doPutOrRemove(attr, value);
                    session.bindValue(attr, value);
                    continue;
                }
                session.doPutOrRemove(attr, value);
            }
            for (String name : session.getNames()) {
                if (attrs.keySet().contains(name)) continue;
                session.doPutOrRemove(name, null);
                session.unbindValue(name, session.getAttribute(name));
            }
        }
    }

    protected synchronized NoSqlSession loadSession(String clusterId) {
        LOG.info("HazelcastSessionManager:loadSession: " + clusterId, new Object[0]);
        HazelcastSessionData o = (HazelcastSessionData)this.sessions.get((Object)clusterId);
        if (o == null) {
            return null;
        }
        Boolean valid = o.isValid();
        if (valid == null || !valid.booleanValue()) {
            return null;
        }
        Object version = o.getVersion();
        Long created = o.getCreationTime();
        Long accessed = o.getAccessed();
        NoSqlSession session = new NoSqlSession((NoSqlSessionManager)this, created.longValue(), accessed.longValue(), clusterId, version);
        Map<String, Object> attrs = o.getAttributeMap();
        if (attrs != null) {
            Iterator<String> i$ = attrs.keySet().iterator();
            while (i$.hasNext()) {
                String name;
                String attr = name = i$.next();
                Object value = attrs.get(name);
                session.doPutOrRemove(attr, value);
                session.bindValue(attr, value);
            }
        }
        session.didActivate();
        return session;
    }

    protected boolean remove(NoSqlSession session) {
        HazelcastSessionData o = (HazelcastSessionData)this.sessions.get((Object)session.getClusterId());
        if (o != null) {
            LOG.debug("HazelcastSessionManager:remove: " + session.getClusterId(), new Object[0]);
            return true;
        }
        return false;
    }

    protected void invalidateSession(String idInCluster) {
        super.invalidateSession(idInCluster);
        HazelcastSessionData o = (HazelcastSessionData)this.sessions.get((Object)idInCluster);
        if (o != null && o.isValid()) {
            o.setValid(false);
            this.sessions.set((Object)idInCluster, (Object)o);
        }
    }

    private String createContextId(String[] virtualHosts, String contextPath) {
        String contextId = virtualHosts[0] + contextPath;
        return contextId;
    }
}

