/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.session.HazelcastSessionData;
import com.hazelcast.session.HazelcastSessionManager;
import com.hazelcast.session.JettySessionUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HazelcastSessionIdManager
extends AbstractSessionIdManager {
    private static final Logger LOG = Log.getLogger((String)"com.hazelcast.session");
    protected final Server server;
    protected final Set<String> sessionsIds = new HashSet<String>();
    private String configLocation;
    private boolean clientOnly;
    private boolean cleanUp = true;
    private Timer cleanUpTimer;
    private TimerTask cleanUpTask;
    private long cleanUpPeriod = 86400000L;
    private long cleanUpInvalidAge = 3600000L;
    private IMap<String, HazelcastSessionData> sessions;
    private HazelcastInstance instance;

    public HazelcastSessionIdManager(Server server) {
        this(server, false, null);
    }

    public HazelcastSessionIdManager(Server server, boolean clientOnly) {
        this(server, clientOnly, null);
    }

    public HazelcastSessionIdManager(Server server, boolean clientOnly, String configLocation) {
        super(new Random());
        this.server = server;
        this.configLocation = configLocation;
        this.clientOnly = clientOnly;
    }

    public HazelcastSessionIdManager(Server server, HazelcastInstance instance) {
        super(new Random());
        this.server = server;
        this.instance = instance;
    }

    public boolean idInUse(String sessionId) {
        LOG.debug("HazelcastSessionIdManager:idInUse:sessionId= " + sessionId, new Object[0]);
        HazelcastSessionData o = (HazelcastSessionData)this.sessions.get((Object)sessionId);
        boolean idInUse = false;
        if (o != null) {
            idInUse = o.isValid();
        }
        LOG.debug("HazelcastSessionIdManager:idInUse:sessionId= " + sessionId + "::" + idInUse, new Object[0]);
        return idInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        LOG.debug("HazelcastSessionIdManager:addSession:" + session.getId(), new Object[0]);
        Set<String> set = this.sessionsIds;
        synchronized (set) {
            this.sessionsIds.add(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(HttpSession session) {
        Set<String> set = this.sessionsIds;
        synchronized (set) {
            this.sessionsIds.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String sessionId) {
        Set<String> set = this.sessionsIds;
        synchronized (set) {
            this.sessionsIds.remove(sessionId);
            Handler[] contexts = this.server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof HazelcastSessionManager)) continue;
                ((HazelcastSessionManager)manager).invalidateSession(sessionId);
            }
        }
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        String worker;
        String string = worker = request == null ? null : (String)request.getAttribute("org.eclipse.jetty.ajp.JVMRoute");
        if (worker != null) {
            return clusterId + '.' + worker;
        }
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    private HazelcastInstance createHazelcastInstance() {
        HazelcastInstance instance = this.clientOnly ? JettySessionUtils.createHazelcastClientInstance(this.getConfigLocation()) : JettySessionUtils.createHazelcastFullInstance(this.getConfigLocation());
        return instance;
    }

    private IMap<String, HazelcastSessionData> initializeSessionMap() {
        return this.instance.getMap("session-replication-map");
    }

    protected void cleanUp() {
        for (Map.Entry entry : this.sessions.entrySet()) {
            if (((HazelcastSessionData)entry.getValue()).getAccessed() >= System.currentTimeMillis() - this.cleanUpInvalidAge) continue;
            this.sessions.remove(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this.instance == null) {
            this.instance = this.createHazelcastInstance();
        }
        this.sessions = this.initializeSessionMap();
        HazelcastSessionIdManager hazelcastSessionIdManager = this;
        synchronized (hazelcastSessionIdManager) {
            if (this.cleanUp) {
                this.cleanUpTimer = new Timer("HazelcastSessionCleaner", true);
                if (this.cleanUpTask != null) {
                    this.cleanUpTask.cancel();
                }
                this.cleanUpTask = new TimerTask(){

                    @Override
                    public void run() {
                        HazelcastSessionIdManager.this.cleanUp();
                    }
                };
                this.cleanUpTimer.schedule(this.cleanUpTask, 0L, this.cleanUpPeriod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        HazelcastSessionIdManager hazelcastSessionIdManager = this;
        synchronized (hazelcastSessionIdManager) {
            if (this.cleanUpTimer != null) {
                this.cleanUpTimer.cancel();
                this.cleanUpTimer = null;
            }
            if (this.clientOnly && this.instance != null) {
                this.instance.shutdown();
                this.instance = null;
            }
        }
        super.doStop();
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public void setClientOnly(boolean clientOnly) {
        this.clientOnly = clientOnly;
    }

    public IMap<String, HazelcastSessionData> getSessions() {
        return this.sessions;
    }

    public void setCleanUp(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public void setCleanUpInvalidAge(long cleanUpInvalidAge) {
        this.cleanUpInvalidAge = cleanUpInvalidAge;
    }

    public void setCleanUpPeriod(long cleanUpPeriod) {
        this.cleanUpPeriod = cleanUpPeriod;
    }
}

