/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.session;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public final class JettySessionUtils {
    public static final String DEFAULT_INSTANCE_NAME = "SESSION-REPLICATION-INSTANCE";
    public static final String DEFAULT_MAP_NAME = "session-replication-map";
    public static final int DAY_IN_MILLISECONDS = 86400000;
    public static final int HOUR_IN_MILLISECONDS = 3600000;

    private JettySessionUtils() {
    }

    public static HazelcastInstance createHazelcastClientInstance() {
        return JettySessionUtils.createHazelcastClientInstance(null);
    }

    public static HazelcastInstance createHazelcastClientInstance(String configLocation) {
        ClientConfig config;
        try {
            XmlClientConfigBuilder builder = configLocation == null ? new XmlClientConfigBuilder() : new XmlClientConfigBuilder(configLocation);
            config = builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load config", e);
        }
        Preconditions.checkNotNull((Object)config, (String)("failed to find configLocation: " + configLocation));
        return HazelcastClient.newHazelcastClient((ClientConfig)config);
    }

    public static HazelcastInstance createHazelcastFullInstance() {
        return JettySessionUtils.createHazelcastFullInstance(null);
    }

    public static HazelcastInstance createHazelcastFullInstance(String configLocation) {
        Config config;
        try {
            config = configLocation == null ? new XmlConfigBuilder().build() : ConfigLoader.load((String)configLocation);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load config", e);
        }
        Preconditions.checkNotNull((Object)config, (String)("failed to find configLocation: " + configLocation));
        config.setInstanceName(DEFAULT_INSTANCE_NAME);
        return Hazelcast.getOrCreateHazelcastInstance((Config)config);
    }
}

